/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.IOException;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.time.InternalSystemClock;
import net.serenitybdd.core.webdriver.driverproviders.AddCustomDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.InternetExplorerServicePool;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetExplorerDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(InternetExplorerDriverProvider.class);
    private final DriverServicePool driverServicePool = new InternetExplorerServicePool();
    private final EnvironmentVariables environmentVariables;
    private final FixtureProviderService fixtureProviderService;

    private DriverServicePool getDriverServicePool() throws IOException {
        this.driverServicePool.ensureServiceIsRunning();
        return this.driverServicePool;
    }

    public InternetExplorerDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        MutableCapabilities mutableCapabilities = enhancer.enhanced(this.recommendedDefaultInternetExplorerCapabilities(), SupportedWebDriver.IEXPLORER);
        SetProxyConfiguration.from(environmentVariables).in(mutableCapabilities);
        this.driverProperties.registerCapabilities("iexplorer", this.capabilitiesToProperties((Capabilities)mutableCapabilities));
        try {
            return this.retryCreateDriverOnNoSuchSession(mutableCapabilities);
        }
        catch (Exception couldNotStartServer) {
            LOGGER.warn("Failed to start the Internet driver service, using a native driver instead - " + couldNotStartServer.getMessage());
            return new InternetExplorerDriver((Capabilities)mutableCapabilities);
        }
    }

    private WebDriver retryCreateDriverOnNoSuchSession(MutableCapabilities mutableCapabilities) throws IOException {
        return new TryAtMost(3).toStartNewDriverWith(mutableCapabilities);
    }

    private MutableCapabilities recommendedDefaultInternetExplorerCapabilities() {
        DesiredCapabilities defaults = DesiredCapabilities.internetExplorer();
        defaults.setCapability("ignoreZoomSetting", true);
        defaults.setCapability("nativeEvents", false);
        defaults.setCapability("requireWindowFocus", false);
        defaults.setCapability("takesScreenshot", true);
        defaults.setCapability("javascriptEnabled", true);
        defaults = AddCustomDriverCapabilities.from(this.environmentVariables).forDriver(SupportedWebDriver.IEXPLORER).to((MutableCapabilities)defaults);
        return defaults;
    }

    private class TryAtMost {
        private final int maxTries;

        private TryAtMost(int maxTries) {
            this.maxTries = maxTries;
        }

        public WebDriver toStartNewDriverWith(MutableCapabilities MutableCapabilities2) throws IOException {
            try {
                return InternetExplorerDriverProvider.this.getDriverServicePool().newDriver((Capabilities)MutableCapabilities2);
            }
            catch (NoSuchSessionException e) {
                if (this.maxTries == 0) {
                    throw e;
                }
                LOGGER.error(((Object)((Object)e)).getClass().getCanonicalName() + " happened - retrying in 2 seconds");
                new InternalSystemClock().pauseFor(2000L);
                return new TryAtMost(this.maxTries - 1).toStartNewDriverWith(MutableCapabilities2);
            }
        }
    }
}

