/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.firefox.FirefoxProfileEnhancer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;

public class FirefoxDriverCapabilities
implements DriverCapabilitiesProvider {
    private final EnvironmentVariables environmentVariables;
    private final FirefoxProfileEnhancer firefoxProfileEnhancer;
    private ProfilesIni allProfiles;

    public FirefoxDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.firefoxProfileEnhancer = new FirefoxProfileEnhancer(environmentVariables);
    }

    @Override
    public MutableCapabilities getCapabilities() {
        FirefoxOptions capabilities = new FirefoxOptions();
        capabilities.setCapability("firefox_profile", (Object)this.buildFirefoxProfile());
        if (ThucydidesSystemProperty.GECKO_FIREFOX_OPTIONS.isDefinedIn(this.environmentVariables)) {
            String firefoxOptionsInJsonFormat = ThucydidesSystemProperty.GECKO_FIREFOX_OPTIONS.from(this.environmentVariables);
            Map firefoxOptions = (Map)new Gson().fromJson(firefoxOptionsInJsonFormat, new TypeToken<HashMap<String, Object>>(){}.getType());
            capabilities.setCapability("moz:firefoxOptions", (Object)firefoxOptions);
        }
        this.addProxyConfigurationTo((MutableCapabilities)capabilities);
        return capabilities;
    }

    private void addProxyConfigurationTo(MutableCapabilities capabilities) {
        String proxyUrl = ThucydidesSystemProperty.SERENITY_PROXY_HTTP.from(this.environmentVariables);
        String proxyPort = ThucydidesSystemProperty.SERENITY_PROXY_HTTP_PORT.from(this.environmentVariables);
        String sslProxy = ThucydidesSystemProperty.SERENITY_PROXY_SSL.from(this.environmentVariables, proxyUrl);
        String sslProxyPort = ThucydidesSystemProperty.SERENITY_PROXY_SSL_PORT.from(this.environmentVariables);
        String proxyType = ThucydidesSystemProperty.SERENITY_PROXY_TYPE.from(this.environmentVariables, "MANUAL");
        if (proxyUrl != null && !proxyUrl.isEmpty()) {
            JsonObject json = new JsonObject();
            if (StringUtils.isNotEmpty((CharSequence)proxyType)) {
                json.addProperty("proxyType", proxyType);
            }
            if (StringUtils.isNotEmpty((CharSequence)proxyUrl)) {
                json.addProperty("httpProxy", proxyUrl);
            }
            if (StringUtils.isNotEmpty((CharSequence)proxyPort)) {
                json.addProperty("httpProxyPort", proxyPort);
            }
            if (StringUtils.isNotEmpty((CharSequence)sslProxy)) {
                json.addProperty("sslProxy", sslProxy);
            }
            if (StringUtils.isNotEmpty((CharSequence)sslProxyPort)) {
                json.addProperty("sslProxyPort", sslProxyPort);
            }
            capabilities.setCapability("proxy", (Object)json);
        }
    }

    private FirefoxProfile buildFirefoxProfile() {
        String profileName = ThucydidesSystemProperty.WEBDRIVER_FIREFOX_PROFILE.from(this.environmentVariables);
        FilePathParser parser = new FilePathParser(this.environmentVariables);
        FirefoxOptions firefoxCapabilities = new FirefoxOptions();
        if (StringUtils.isNotEmpty((CharSequence)profileName)) {
            firefoxCapabilities.setCapability("firefox_profile", parser.getInstanciatedPath(profileName));
        }
        FirefoxProfile profile = profileName == null ? this.createNewFirefoxProfile() : this.getProfileFrom(profileName);
        this.firefoxProfileEnhancer.allowWindowResizeFor(profile);
        if (this.shouldActivateProxy()) {
            this.activateProxyFor(profile, this.firefoxProfileEnhancer);
        }
        if (this.refuseUntrustedCertificates()) {
            profile.setAssumeUntrustedCertificateIssuer(false);
            profile.setAcceptUntrustedCertificates(false);
        } else {
            profile.setAssumeUntrustedCertificateIssuer(true);
            profile.setAcceptUntrustedCertificates(true);
        }
        this.firefoxProfileEnhancer.configureJavaSupport(profile);
        this.firefoxProfileEnhancer.addPreferences(profile);
        return profile;
    }

    private void activateProxyFor(FirefoxProfile profile, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        String proxyPort = this.getProxyPortFromEnvironmentVariables();
        firefoxProfileEnhancer.activateProxy(profile, proxyUrl, proxyPort);
    }

    private String getProxyPortFromEnvironmentVariables() {
        return ThucydidesSystemProperty.SERENITY_PROXY_HTTP_PORT.from(this.environmentVariables);
    }

    private boolean shouldActivateProxy() {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        return StringUtils.isNotEmpty((CharSequence)proxyUrl);
    }

    private String getProxyUrlFromEnvironmentVariables() {
        return ThucydidesSystemProperty.SERENITY_PROXY_HTTP.from(this.environmentVariables);
    }

    private FirefoxProfile getProfileFrom(String profileName) {
        FirefoxProfile profile = this.getAllProfiles().getProfile(profileName);
        if (profile == null) {
            profile = this.useExistingFirefoxProfile(new File(profileName));
        }
        return profile;
    }

    private ProfilesIni getAllProfiles() {
        if (this.allProfiles == null) {
            this.allProfiles = new ProfilesIni();
        }
        return this.allProfiles;
    }

    private FirefoxProfile createNewFirefoxProfile() {
        FirefoxProfile profile;
        if (Serenity.getFirefoxProfile() != null) {
            profile = Serenity.getFirefoxProfile();
        } else {
            profile = new FirefoxProfile();
            profile.setPreference("network.proxy.socks_port", 9999);
            profile.setAlwaysLoadNoFocusLib(true);
        }
        return profile;
    }

    private FirefoxProfile useExistingFirefoxProfile(File profileDirectory) {
        return new FirefoxProfile(profileDirectory);
    }

    private boolean refuseUntrustedCertificates() {
        return ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.booleanFrom(this.environmentVariables);
    }
}

