/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.io.File;

public class ScreenshotAndHtmlSource {
    private final File screenshot;
    private final File htmlSource;

    public ScreenshotAndHtmlSource(String screenshotName, String sourcecodeName) {
        this.screenshot = new File(screenshotName);
        this.htmlSource = sourcecodeName != null ? new File(sourcecodeName) : null;
    }

    public ScreenshotAndHtmlSource(File screenshot, File sourcecode) {
        this.screenshot = screenshot;
        this.htmlSource = sourcecode;
    }

    public String getScreenshotName() {
        return this.screenshot.getName();
    }

    public String getHtmlSourceName() {
        if (this.htmlSource == null) {
            return null;
        }
        return this.htmlSource.getName();
    }

    public ScreenshotAndHtmlSource(File screenshot) {
        this(screenshot, null);
    }

    public File getScreenshot() {
        return this.screenshot;
    }

    public Optional<File> getHtmlSource() {
        return Optional.fromNullable((Object)this.htmlSource);
    }

    public boolean wasTaken() {
        return this.screenshot != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenshotAndHtmlSource that = (ScreenshotAndHtmlSource)o;
        return Objects.equal((Object)this.screenshot, (Object)that.screenshot) && Objects.equal((Object)this.htmlSource, (Object)that.htmlSource);
    }

    public int hashCode() {
        return this.screenshot != null ? this.screenshot.hashCode() : 0;
    }

    public boolean hasIdenticalScreenshotsAs(ScreenshotAndHtmlSource anotherScreenshotAndHtmlSource) {
        if (this.hasNoScreenshot() || anotherScreenshotAndHtmlSource.hasNoScreenshot()) {
            return false;
        }
        return this.getScreenshot().getName().equals(anotherScreenshotAndHtmlSource.getScreenshot().getName());
    }

    public File getScreenshotFile(File screenshotTargetDirectory) {
        return new File(screenshotTargetDirectory, this.getScreenshot().getName());
    }

    public boolean hasNoScreenshot() {
        return this.getScreenshot() == null;
    }
}

