/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.TestTag;

public class Breadcrumbs {
    public static BreadcrumbsBuilder forRequirementsTag(TestTag tag) {
        return new BreadcrumbsBuilder(tag);
    }

    public static class BreadcrumbsBuilder {
        private final TestTag tag;

        public BreadcrumbsBuilder(TestTag tag) {
            this.tag = tag;
        }

        public List<TestTag> fromTagsIn(List<TestTag> allTags) {
            if (this.isAnOrphan(this.tag.getName())) {
                return new ArrayList<TestTag>();
            }
            String parentName = this.parentElementOf(this.tag.getName());
            Optional<TestTag> parentTag = this.parentTagNamed(parentName).from(allTags);
            if (!parentTag.isPresent()) {
                return new ArrayList<TestTag>();
            }
            List<TestTag> ancestors = Breadcrumbs.forRequirementsTag((TestTag)parentTag.get()).fromTagsIn(allTags);
            ancestors.add((TestTag)parentTag.get());
            return ancestors;
        }

        private boolean isAnOrphan(String name) {
            return this.elementsOf(name).size() == 1;
        }

        private List<String> elementsOf(String name) {
            return Splitter.on((String)"/").splitToList((CharSequence)name);
        }

        private String parentElementOf(String name) {
            return this.elementsOf(name).get(0);
        }

        private ParentTagFinder parentTagNamed(String parentName) {
            return new ParentTagFinder(parentName);
        }

        private class ParentTagFinder {
            private final String parentName;

            public ParentTagFinder(String parentName) {
                this.parentName = parentName;
            }

            public Optional<TestTag> from(List<TestTag> allTags) {
                for (TestTag tag : allTags) {
                    if (!tag.getName().equals(this.parentName) && !tag.getName().endsWith("/" + this.parentName)) continue;
                    return Optional.of((Object)tag);
                }
                return Optional.absent();
            }
        }
    }
}

