/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.ThucydidesReporter;
import net.thucydides.core.reports.html.HtmlResourceCopier;
import net.thucydides.core.reports.html.Merger;
import net.thucydides.core.reports.html.TestOutcomeTimestamp;
import net.thucydides.core.reports.templates.TemplateManager;
import net.thucydides.core.reports.util.CopyDirectory;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HtmlReporter
extends ThucydidesReporter {
    private static final String DEFAULT_RESOURCE_DIRECTORY = "report-resources";
    private static final String DEFAULT_SOURCE_DIR = "target/site/serenity";
    private String resourceDirectory = "report-resources";
    private final TemplateManager templateManager = (TemplateManager)Injectors.getInjector().getInstance(TemplateManager.class);
    private final EnvironmentVariables environmentVariables;
    private final Charset charset;
    protected static final String TIMESTAMP_FORMAT = "dd-MM-YYYY HH:mm";
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReporter.class);

    public HtmlReporter() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public HtmlReporter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.charset = Charset.forName(ThucydidesSystemProperty.JSON_CHARSET.from(environmentVariables, StandardCharsets.UTF_8.name()));
    }

    private TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    protected void copyResourcesToOutputDirectory() throws IOException {
        this.updateResourceDirectoryFromSystemPropertyIfDefined();
        HtmlResourceCopier.copyHtmlResourcesFrom(this.getResourceDirectory()).to(this.getOutputDirectory());
    }

    protected void copyTestResultsToOutputDirectory() throws IOException {
        Path sourcePath = this.getSourceDirectoryOrDefault().toPath();
        Path destinationPath = this.getOutputDirectory().toPath();
        if (Files.exists(sourcePath, new LinkOption[0]) && !Files.isSameFile(sourcePath, destinationPath)) {
            LOGGER.debug("Copying directory contents from {} to {}", (Object)sourcePath, (Object)destinationPath);
            this.copyDirectoryContents(sourcePath, destinationPath);
            LOGGER.debug("Copying directory contents from {} to {} done", (Object)sourcePath, (Object)destinationPath);
        }
    }

    private void copyDirectoryContents(Path sourcePath, Path destinationPath) throws IOException {
        Files.walkFileTree(sourcePath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new CopyDirectory(sourcePath, destinationPath));
    }

    private File getSourceDirectoryOrDefault() {
        String source = this.getSourceDirectory() != null ? this.getSourceDirectory().getAbsolutePath() : DEFAULT_SOURCE_DIR;
        return new File(source);
    }

    private void updateResourceDirectoryFromSystemPropertyIfDefined() {
        String systemDefinedResourceDirectory = ThucydidesSystemProperty.THUCYDIDES_REPORT_RESOURCES.from(this.environmentVariables);
        if (systemDefinedResourceDirectory != null) {
            this.setResourceDirectory(systemDefinedResourceDirectory);
        }
    }

    protected void addTimestamp(TestOutcome testOutcome, Map<String, Object> context) {
        context.put("timestamp", TestOutcomeTimestamp.from(testOutcome));
    }

    protected Merger mergeTemplate(String templateFile) {
        return new Merger(templateFile);
    }
}

