/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import io.appium.java_client.AppiumDriver;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.capabilities.BrowserStackRemoteDriverCapabilities;
import net.thucydides.core.webdriver.capabilities.SauceRemoteDriverCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DriverStrategySelector {
    private final EnvironmentVariables environmentVariables;
    private final SauceRemoteDriverCapabilities sauceRemoteDriverCapabilities;
    private final BrowserStackRemoteDriverCapabilities browserStackRemoteDriverCapabilities;

    public DriverStrategySelector(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.browserStackRemoteDriverCapabilities = new BrowserStackRemoteDriverCapabilities(environmentVariables);
        this.sauceRemoteDriverCapabilities = new SauceRemoteDriverCapabilities(environmentVariables);
    }

    public static DriverStrategySelector inEnvironment(EnvironmentVariables environmentVariables) {
        return new DriverStrategySelector(environmentVariables);
    }

    public SupportedWebDriver forDriverClass(Class<? extends WebDriver> driverClass) {
        if (this.isARemoteDriver(driverClass) || this.shouldUseARemoteDriver() || this.saucelabsUrlIsDefined() || this.browserStackUrlIsDefined()) {
            return SupportedWebDriver.REMOTE;
        }
        return SupportedWebDriver.forClass(driverClass);
    }

    public boolean isARemoteDriver(Class<? extends WebDriver> driverClass) {
        return RemoteWebDriver.class == driverClass;
    }

    public boolean shouldUseARemoteDriver() {
        return ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.isDefinedIn(this.environmentVariables);
    }

    public boolean saucelabsUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.sauceRemoteDriverCapabilities.getUrl());
    }

    public boolean browserStackUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.browserStackRemoteDriverCapabilities.getUrl());
    }

    public boolean supportsResizing(Class<? extends WebDriver> driverClass) {
        return !AppiumDriver.class.isAssignableFrom(driverClass) && !HtmlUnitDriver.class.isAssignableFrom(driverClass);
    }
}

