/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.Breadcrumbs;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;

public class TagReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String TEST_OUTCOME_TEMPLATE_PATH = "freemarker/home.ftl";
    protected ReportNameProvider reportNameProvider;
    private final TestTag tag;
    private final List<TestTag> allTags;
    private final TestOutcomes testOutcomes;
    private final String reportName;

    protected TagReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, String reportName, TestTag tag, List<TestTag> allTags, TestOutcomes testOutcomes) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.tag = tag;
        this.allTags = allTags;
        this.testOutcomes = testOutcomes;
        this.reportName = reportName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagReportingTask that = (TagReportingTask)o;
        return Objects.equal((Object)this.reportName, (Object)that.reportName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName});
    }

    public static TagReportBuilder tagReportsFor(TestOutcomes testOutcomes) {
        return new TagReportBuilder(testOutcomes);
    }

    @Override
    public void generateReports() throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        this.generateTagReport(this.testOutcomes, this.reportNameProvider, this.tag);
        LOGGER.trace("Tag reports generated: {} ms", (Object)stopwatch.stop());
    }

    void generateTagReport(TestOutcomes testOutcomes, ReportNameProvider reportNameProvider, TestTag tag) throws IOException {
        LOGGER.debug("GENERATE TAG REPORTS FOR " + tag);
        TestOutcomes testOutcomesForTag = testOutcomes.withTag(tag);
        Map<String, Object> context = this.freemarker.getBuildContext(testOutcomesForTag, reportNameProvider, true);
        context.put("report", ReportProperties.forTagResultsReport());
        context.put("currentTagType", tag.getType());
        context.put("currentTag", tag);
        String csvReport = reportNameProvider.forCSVFiles().forTag(tag);
        context.put("csvReport", csvReport);
        context.put("breadcrumbs", Breadcrumbs.forRequirementsTag(tag).fromTagsIn(this.allTags));
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, this.reportName);
        this.generateCSVReportFor(testOutcomesForTag, csvReport);
        String linkableReport = reportNameProvider.inLinkableForm().forTag(tag);
        if (!linkableReport.equals(this.reportName) && this.shouldGenerateLinkableReportsFor(tag, reportNameProvider)) {
            this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, linkableReport);
        }
    }

    private boolean shouldGenerateLinkableReportsFor(TestTag tag, ReportNameProvider reportName) {
        if (reportName.getContext().isEmpty()) {
            return false;
        }
        List linkableTags = Splitter.on((String)",").trimResults().splitToList((CharSequence)ThucydidesSystemProperty.SERENITY_LINKED_TAGS.from(this.environmentVariables, "").toLowerCase());
        return this.containsTag(linkableTags, tag.getType().toLowerCase()) || this.containsTag(linkableTags, tag.getName().toLowerCase());
    }

    private boolean containsTag(List<String> linkableTags, String tag) {
        for (String linkableTag : linkableTags) {
            if (!linkableTag.equalsIgnoreCase(tag)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "TagReportingTask for " + this.tag;
    }

    public static class TagReportBuilder {
        private final TestOutcomes testOutcomes;

        public TagReportBuilder(TestOutcomes testOutcomes) {
            this.testOutcomes = testOutcomes;
        }

        public Set<ReportingTask> using(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, List<TestTag> allTags, List<String> knownRequirementReportNames) {
            HashSet<ReportingTask> reportingTasks = new HashSet<ReportingTask>();
            for (TestTag tag : this.testOutcomes.getTags()) {
                String reportName = reportNameProvider.forTag(tag);
                if (knownRequirementReportNames.contains(reportName)) continue;
                reportingTasks.add(new TagReportingTask(freemarker, environmentVariables, outputDirectory, reportNameProvider, reportName, tag, allTags, this.testOutcomes));
            }
            return reportingTasks;
        }
    }
}

