/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.injectors;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;

public class EnvironmentDependencyInjector
implements DependencyInjector {
    private final EnvironmentVariables environmentVariables = ConfiguredEnvironment.getEnvironmentVariables();
    private final Configuration systemPropertiesConfiguration = ConfiguredEnvironment.getConfiguration();

    @Override
    public void injectDependenciesInto(Object target) {
        List<Field> environmentVariableFields = this.matchingFieldsIn(target, EnvironmentVariables.class);
        for (Field environmentVariableField : environmentVariableFields) {
            this.injectEnvironmentVariables(environmentVariableField, target);
        }
        List<Field> sysConfigVariableFields = this.matchingFieldsIn(target, Configuration.class);
        for (Field sysConfigVariableField : sysConfigVariableFields) {
            this.injectSysConfigVariables(sysConfigVariableField, target);
        }
    }

    @Override
    public void reset() {
    }

    private void injectEnvironmentVariables(Field field, Object target) {
        try {
            field.setAccessible(true);
            if (field.get(target) == null) {
                field.set(target, this.environmentVariables);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate environmentVariables in " + target);
        }
    }

    private void injectSysConfigVariables(Field field, Object target) {
        try {
            field.setAccessible(true);
            if (field.get(target) == null) {
                field.set(target, this.systemPropertiesConfiguration);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate systemPropertiesConfiguration in " + target);
        }
    }

    private List<Field> matchingFieldsIn(Object target, Class fieldClass) {
        Set<Field> allFields = Fields.of(target.getClass()).allFields();
        ArrayList matchingFields = Lists.newArrayList();
        for (Field field : allFields) {
            if (!fieldClass.isAssignableFrom(field.getType())) continue;
            matchingFields.add(field);
        }
        return matchingFields;
    }
}

