/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.tags;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;

public class BreadcrumbTagFilter {
    private final RequirementsService requirementsService;

    public BreadcrumbTagFilter(RequirementsService requirementsService) {
        this.requirementsService = requirementsService;
    }

    public BreadcrumbTagFilter() {
        this((RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public boolean isRequirementTag(TestTag tag) {
        return this.requirementsService.isRequirementsTag(tag);
    }

    public List<TestTag> getRequirementBreadcrumbsFrom(Collection<TestTag> tags) {
        List requirementTypeTags = Lists.newArrayList();
        for (String requirementType : this.requirementsService.getRequirementTypes()) {
            requirementTypeTags.addAll(this.requirementTagOfType(requirementType).in(tags).asSet());
        }
        return requirementTypeTags;
    }

    private RequirementTagFilter requirementTagOfType(String requirementType) {
        return new RequirementTagFilter(requirementType);
    }

    public List<TestTag> getRequirementBreadcrumbsFrom(RequirementsOutcomes requirementsOutcomes) {
        List breadcrumbs = Lists.newArrayList();
        if (requirementsOutcomes.getParentRequirement().isPresent()) {
            breadcrumbs.add(((Requirement)requirementsOutcomes.getParentRequirement().get()).asTag());
        }
        return breadcrumbs;
    }

    public static class RequirementTagFilter {
        private String requirementType;

        public RequirementTagFilter(String requirementType) {
            this.requirementType = requirementType;
        }

        public Optional<TestTag> in(Collection<TestTag> tags) {
            for (TestTag tag : tags) {
                if (!tag.getType().equals(this.requirementType)) continue;
                return Optional.of((Object)tag);
            }
            return Optional.absent();
        }
    }
}

