/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepInterceptor;
import net.thucydides.core.steps.di.DependencyInjectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepFactory {
    private final Pages pages;
    private final Map<Class<?>, Object> index = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(StepFactory.class);
    private final DependencyInjectorService dependencyInjectorService;
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES = new Class[]{Pages.class};

    public StepFactory(Pages pages) {
        this.pages = pages;
        this.dependencyInjectorService = (DependencyInjectorService)Injectors.getInjector().getInstance(DependencyInjectorService.class);
    }

    public StepFactory() {
        this(null);
    }

    public <T> T getStepLibraryFor(Class<T> scenarioStepsClass) {
        if (this.isStepLibraryInstantiatedFor(scenarioStepsClass)) {
            return this.getManagedStepLibraryFor(scenarioStepsClass);
        }
        return this.getNewStepLibraryFor(scenarioStepsClass);
    }

    public <T> T getNewStepLibraryFor(Class<T> scenarioStepsClass) {
        return this.instantiateNewStepLibraryFor(scenarioStepsClass);
    }

    public <T> T getUniqueStepLibraryFor(Class<T> scenarioStepsClass) {
        return this.instantiateUniqueStepLibraryFor(scenarioStepsClass);
    }

    public void reset() {
        this.index.clear();
    }

    private boolean isStepLibraryInstantiatedFor(Class<?> scenarioStepsClass) {
        return this.index.containsKey(scenarioStepsClass);
    }

    private <T> T getManagedStepLibraryFor(Class<T> scenarioStepsClass) {
        return (T)this.index.get(scenarioStepsClass);
    }

    public <T> T instantiateNewStepLibraryFor(Class<T> scenarioStepsClass) {
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass);
        return this.instantiateNewStepLibraryFor(scenarioStepsClass, stepInterceptor);
    }

    public <T> T instantiateNewStepLibraryFor(Class<T> scenarioStepsClass, MethodInterceptor interceptor) {
        T steps = this.createProxyStepLibrary(scenarioStepsClass, interceptor);
        this.indexStepLibrary(scenarioStepsClass, steps);
        this.instantiateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        this.injectOtherDependenciesInto(steps);
        return steps;
    }

    private <T> void injectOtherDependenciesInto(T steps) {
        List<DependencyInjector> dependencyInjectors = this.dependencyInjectorService.findDependencyInjectors();
        dependencyInjectors.addAll((Collection<DependencyInjector>)this.getDefaultDependencyInjectors());
        for (DependencyInjector dependencyInjector : dependencyInjectors) {
            dependencyInjector.injectDependenciesInto(steps);
        }
    }

    private ImmutableList<? extends DependencyInjector> getDefaultDependencyInjectors() {
        return this.pages != null ? ImmutableList.of((Object)new PageObjectDependencyInjector(this.pages), (Object)new EnvironmentDependencyInjector()) : ImmutableList.of((Object)new EnvironmentDependencyInjector());
    }

    private <T> T instantiateUniqueStepLibraryFor(Class<T> scenarioStepsClass) {
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass);
        T steps = this.createProxyStepLibrary(scenarioStepsClass, stepInterceptor);
        this.instantiateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        this.injectOtherDependenciesInto(steps);
        return steps;
    }

    private <T> T createProxyStepLibrary(Class<T> scenarioStepsClass, MethodInterceptor interceptor) {
        Enhancer e = new Enhancer();
        e.setSuperclass(scenarioStepsClass);
        e.setCallback((Callback)interceptor);
        if (this.isWebdriverStepClass(scenarioStepsClass)) {
            return this.webEnabledStepLibrary(scenarioStepsClass, e);
        }
        return (T)e.create();
    }

    private <T> T webEnabledStepLibrary(Class<T> scenarioStepsClass, Enhancer e) {
        if (this.hasAPagesConstructor(scenarioStepsClass)) {
            Object[] arguments = new Object[]{this.pages};
            return (T)e.create((Class[])CONSTRUCTOR_ARG_TYPES, arguments);
        }
        Object newStepLibrary = e.create();
        return (T)this.injectPagesInto(scenarioStepsClass, newStepLibrary);
    }

    private <T> T injectPagesInto(Class<T> stepLibraryClass, T newStepLibrary) {
        if (ScenarioSteps.class.isAssignableFrom(stepLibraryClass)) {
            ((ScenarioSteps)newStepLibrary).setPages(this.pages);
        } else if (this.hasAPagesField(stepLibraryClass)) {
            ImmutableSet fields = ImmutableSet.copyOf(Fields.of(stepLibraryClass).allFields());
            Field pagesField = (Field)Iterables.find((Iterable)fields, this.ofTypePages());
            pagesField.setAccessible(true);
            try {
                pagesField.set(newStepLibrary, this.pages);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not instantiate pages field for step library {}", newStepLibrary);
            }
        }
        return newStepLibrary;
    }

    private <T> boolean isWebdriverStepClass(Class<T> stepLibraryClass) {
        return this.isAScenarioStepClass(stepLibraryClass) || this.hasAPagesConstructor(stepLibraryClass) || this.hasAPagesField(stepLibraryClass);
    }

    private <T> boolean hasAPagesConstructor(Class<T> stepLibraryClass) {
        ImmutableSet constructors = ImmutableSet.copyOf((Object[])stepLibraryClass.getDeclaredConstructors());
        return Iterables.any((Iterable)constructors, this.withASinglePagesParameter());
    }

    private <T> boolean hasAPagesField(Class<T> stepLibraryClass) {
        ImmutableSet fields = ImmutableSet.copyOf(Fields.of(stepLibraryClass).allFields());
        return Iterables.any((Iterable)fields, this.ofTypePages());
    }

    private Predicate<Constructor> withASinglePagesParameter() {
        return new Predicate<Constructor>(){

            public boolean apply(Constructor constructor) {
                return constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == Pages.class;
            }
        };
    }

    private Predicate<Field> ofTypePages() {
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return field.getType() == Pages.class;
            }
        };
    }

    private <T> boolean isAScenarioStepClass(Class<T> stepLibraryClass) {
        return ScenarioSteps.class.isAssignableFrom(stepLibraryClass);
    }

    private <T> void indexStepLibrary(Class<T> scenarioStepsClass, T steps) {
        this.index.put(scenarioStepsClass, steps);
    }

    private <T> void instantiateAnyNestedStepLibrariesIn(T steps, Class<T> scenarioStepsClass) {
        StepAnnotations.injectNestedScenarioStepsInto(steps, this, scenarioStepsClass);
    }
}

