/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import net.thucydides.core.reflection.MethodFinder;
import net.thucydides.core.util.NameConverter;

public class ExecutedStepDescription
implements Cloneable {
    private final Class<? extends Object> stepsClass;
    private final String name;
    private final Map<String, Object> displayedFields;
    private boolean isAGroup;
    private static final Map<String, Object> NO_FIELDS = Maps.newHashMap();

    protected ExecutedStepDescription(Class<? extends Object> stepsClass, String name, Map<String, Object> displayedFields, boolean isAGroup) {
        this.stepsClass = stepsClass;
        this.name = name;
        this.displayedFields = displayedFields;
        this.isAGroup = isAGroup;
    }

    protected ExecutedStepDescription(Class<? extends Object> stepsClass, String name, boolean isAGroup) {
        this(stepsClass, name, NO_FIELDS, isAGroup);
    }

    protected ExecutedStepDescription(Class<? extends Object> stepsClass, String name) {
        this(stepsClass, name, NO_FIELDS, false);
    }

    protected ExecutedStepDescription(String name) {
        this(null, name, NO_FIELDS, false);
    }

    public ExecutedStepDescription clone() {
        return new ExecutedStepDescription(this.stepsClass, this.name, this.displayedFields, this.isAGroup);
    }

    public Class<? extends Object> getStepClass() {
        return this.stepsClass;
    }

    public String getName() {
        return this.name;
    }

    public ExecutedStepDescription withName(String newName) {
        return new ExecutedStepDescription(this.stepsClass, newName, this.isAGroup);
    }

    public ExecutedStepDescription withDisplayedFields(Map<String, Object> displayedFields) {
        return new ExecutedStepDescription(this.stepsClass, this.name, displayedFields, this.isAGroup);
    }

    public static ExecutedStepDescription of(Class<? extends Object> stepsClass, String name) {
        return new ExecutedStepDescription(stepsClass, name, NO_FIELDS, false);
    }

    public static ExecutedStepDescription withTitle(String name) {
        return new ExecutedStepDescription(name);
    }

    public boolean isAGroup() {
        return this.isAGroup;
    }

    public void setAGroup(boolean aGroup) {
        this.isAGroup = aGroup;
    }

    public Method getTestMethod() {
        if (this.getStepClass() != null) {
            return this.methodCalled(NameConverter.withNoArguments(this.getName()), this.getStepClass());
        }
        return null;
    }

    private Method methodCalled(String methodName, Class<?> testClass) {
        Method method = MethodFinder.inClass(testClass).getMethodNamed(methodName);
        if (method == null) {
            throw new IllegalArgumentException("No test method called " + methodName + " was found in " + testClass);
        }
        return method;
    }

    public String getTitle() {
        return NameConverter.humanize(this.name);
    }

    public Map<String, Object> getDisplayedFields() {
        return this.displayedFields;
    }
}

