/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.annotations.TestsRequirement;
import net.thucydides.core.annotations.TestsRequirements;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.reflection.MethodFinder;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.TestStatus;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public final class AnnotatedStepDescription {
    private static final List<String> VALID_STEP_ANNOTATIONS = ImmutableList.of((Object)"Step", (Object)"Given", (Object)"When", (Object)"Then");
    private final ExecutedStepDescription description;

    public static AnnotatedStepDescription from(ExecutedStepDescription description) {
        return new AnnotatedStepDescription(description);
    }

    private AnnotatedStepDescription(ExecutedStepDescription description) {
        this.description = description;
    }

    public List<String> getAnnotatedRequirements() {
        ArrayList<String> requirements = new ArrayList<String>();
        Method testMethod = this.getTestMethod();
        if (testMethod != null) {
            this.addRequirementFrom(requirements, testMethod);
            this.addMultipleRequirementsFrom(requirements, testMethod);
        }
        return requirements;
    }

    private void addMultipleRequirementsFrom(List<String> requirements, Method testMethod) {
        TestsRequirements testRequirements = testMethod.getAnnotation(TestsRequirements.class);
        if (testRequirements != null) {
            requirements.addAll(Arrays.asList(testRequirements.value()));
        }
    }

    private void addRequirementFrom(List<String> requirements, Method testMethod) {
        TestsRequirement testsRequirement = testMethod.getAnnotation(TestsRequirement.class);
        if (testsRequirement != null) {
            requirements.add(testsRequirement.value());
        }
    }

    public Method getTestMethod() {
        if (this.getTestClass() != null) {
            return this.methodCalled(this.withNoArguments(this.description.getName()), this.getTestClass());
        }
        return null;
    }

    public Method getTestMethodIfPresent() {
        return this.findMethodCalled(this.withNoArguments(this.description.getName()), this.getTestClass());
    }

    private String withNoArguments(String methodName) {
        String unqualifiedName = this.unqualified(methodName);
        return this.stripFrom(':', unqualifiedName);
    }

    private String stripFrom(char boundaryChar, String text) {
        int boundaryPosition = text.indexOf(boundaryChar);
        if (boundaryPosition > 0) {
            return text.substring(0, boundaryPosition);
        }
        return text;
    }

    private String unqualified(String methodName) {
        return StringUtils.stripStart((String)methodName, (String)"[0123456789] ");
    }

    private Class<?> getTestClass() {
        return this.description.getStepClass();
    }

    private Method methodCalled(String methodName, Class<?> testClass) {
        Method methodFound = this.findMethodCalled(methodName, testClass);
        if (methodFound == null) {
            throw new IllegalArgumentException("No test method called " + methodName + " was found in " + testClass);
        }
        return methodFound;
    }

    private Method findMethodCalled(String methodName, Class<?> testClass) {
        return MethodFinder.inClass(testClass).getMethodNamed(methodName);
    }

    public String getAnnotatedTitle() {
        Method testMethod = this.getTestMethod();
        Title title = testMethod.getAnnotation(Title.class);
        if (title != null) {
            return title.value();
        }
        return null;
    }

    private Optional<String> getAnnotatedStepName() {
        Optional<String> stepAnnotatedName = this.getNameFromStepAnnotationIn(this.getTestMethod());
        if (stepAnnotatedName.isPresent()) {
            return stepAnnotatedName;
        }
        return this.getCompatibleStepNameFrom(this.getTestMethod());
    }

    public static boolean isACompatibleStep(Annotation annotation) {
        return VALID_STEP_ANNOTATIONS.contains(annotation.annotationType().getSimpleName());
    }

    private Optional<String> getCompatibleStepNameFrom(Method testMethod) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = testMethod.getAnnotations()) {
            if (!AnnotatedStepDescription.isACompatibleStep(annotation)) continue;
            try {
                String annotationType = annotation.annotationType().getSimpleName();
                String annotatedValue = (String)annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                if (StringUtils.isEmpty((CharSequence)annotatedValue)) {
                    return Optional.absent();
                }
                return Optional.of((Object)(annotationType + " " + StringUtils.uncapitalize((String)annotatedValue)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.absent();
    }

    private Optional<String> getNameFromStepAnnotationIn(Method testMethod) {
        Step step = testMethod.getAnnotation(Step.class);
        if (step != null && !StringUtils.isEmpty((CharSequence)step.value())) {
            return Optional.of((Object)this.injectAnnotatedFieldValuesFrom(this.description).into(step.value()));
        }
        return Optional.absent();
    }

    private AnnotatedFieldValuesBuilder injectAnnotatedFieldValuesFrom(ExecutedStepDescription description) {
        return new AnnotatedFieldValuesBuilder(description);
    }

    private String fieldNameFor(String field) {
        return "#" + field;
    }

    public String getName() {
        if (this.noClassIsDefined()) {
            return this.description.getName();
        }
        if (this.isAGroup()) {
            return this.groupName();
        }
        return this.stepName();
    }

    private boolean noClassIsDefined() {
        return this.description.getStepClass() == null;
    }

    private String groupName() {
        String annotatedGroupName = this.getGroupName();
        if (!StringUtils.isEmpty((CharSequence)annotatedGroupName)) {
            return annotatedGroupName;
        }
        return this.stepName();
    }

    private String stepName() {
        String annotationTitle = this.getAnnotatedTitle();
        if (!StringUtils.isEmpty((CharSequence)annotationTitle)) {
            return annotationTitle;
        }
        Optional<String> annotatedStepName = this.getAnnotatedStepName();
        if (this.getAnnotatedStepName().isPresent() && StringUtils.isNotEmpty((CharSequence)((CharSequence)annotatedStepName.get()))) {
            return this.annotatedStepNameWithParameters((String)annotatedStepName.get());
        }
        return NameConverter.humanize(this.description.getName());
    }

    private String annotatedStepNameWithParameters(String annotatedStepTemplate) {
        String annotatedStepName = annotatedStepTemplate;
        Iterable<String> parameters = this.getParamatersFrom(this.description.getName());
        int counter = 0;
        for (String parameter : parameters) {
            String token = "{" + counter++ + "}";
            annotatedStepName = StringUtils.replace((String)annotatedStepName, (String)token, (String)parameter);
        }
        return annotatedStepName;
    }

    private Iterable<String> getParamatersFrom(String name) {
        String parameters = StringUtils.substringAfter((String)name, (String)":");
        return Splitter.on((String)",").trimResults().split((CharSequence)parameters);
    }

    public boolean isAGroup() {
        Method testMethod = this.getTestMethodIfPresent();
        if (testMethod != null) {
            StepGroup testGroup = testMethod.getAnnotation(StepGroup.class);
            return testGroup != null;
        }
        return false;
    }

    private String getGroupName() {
        Method testMethod = this.getTestMethodIfPresent();
        StepGroup testGroup = testMethod.getAnnotation(StepGroup.class);
        return testGroup.value();
    }

    public boolean isPending() {
        Method testMethod = this.getTestMethodIfPresent();
        return testMethod != null && TestStatus.of(testMethod).isPending();
    }

    public boolean isIgnored() {
        Method testMethod = this.getTestMethodIfPresent();
        return testMethod != null && TestStatus.of(testMethod).isIgnored();
    }

    public boolean isFluent() {
        if (this.description.getTestMethod() != null) {
            Step step = this.description.getTestMethod().getAnnotation(Step.class);
            return step != null && step.fluent();
        }
        return false;
    }

    private class AnnotatedFieldValuesBuilder {
        private final ExecutedStepDescription description;

        private AnnotatedFieldValuesBuilder(ExecutedStepDescription description) {
            this.description = description;
        }

        public String into(String stepDescription) {
            Map<String, Object> fields = this.description.getDisplayedFields();
            for (String field : fields.keySet()) {
                String fieldName = AnnotatedStepDescription.this.fieldNameFor(field);
                Object value = fields.get(field);
                if (!stepDescription.contains(fieldName) || value == Fields.FieldValue.UNDEFINED) continue;
                stepDescription = StringUtils.replace((String)stepDescription, (String)AnnotatedStepDescription.this.fieldNameFor(field), (String)value.toString());
            }
            return stepDescription;
        }

        private void allStepDefinitionFieldsShouldBeResolvedIn(String stepDescription) {
            Map<String, Object> fields = this.description.getDisplayedFields();
            for (String field : fields.keySet()) {
                if (stepDescription.contains(AnnotatedStepDescription.this.fieldNameFor(field))) {
                    throw new AssertionError((Object)(stepDescription + " : " + field + " value could not be resolved"));
                }
            }
        }
    }
}

