/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ExecutorServiceProvider;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.ReportGenerationFailedError;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.junit.JUnitXMLOutcomeReporter;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportService {
    private File outputDirectory;
    private List<AcceptanceTestReporter> subscribedReporters;
    private JUnitXMLOutcomeReporter jUnitXMLOutcomeReporter;
    private ExecutorService executorService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportService.class);

    @Inject
    public ReportService(Configuration configuration) {
        this(configuration.getOutputDirectory(), ReportService.getDefaultReporters());
    }

    public ReportService(File outputDirectory, Collection<AcceptanceTestReporter> subscribedReporters) {
        this.outputDirectory = outputDirectory;
        this.getSubscribedReporters().addAll(subscribedReporters);
        this.jUnitXMLOutcomeReporter = new JUnitXMLOutcomeReporter(outputDirectory);
        this.executorService = ((ExecutorServiceProvider)Injectors.getInjector().getInstance(ExecutorServiceProvider.class)).getExecutorService();
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<AcceptanceTestReporter> getSubscribedReporters() {
        if (this.subscribedReporters == null) {
            this.subscribedReporters = new ArrayList<AcceptanceTestReporter>();
        }
        return this.subscribedReporters;
    }

    public void subscribe(AcceptanceTestReporter reporter) {
        this.getSubscribedReporters().add(reporter);
    }

    public void useQualifier(String qualifier) {
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            reporter.setQualifier(qualifier);
        }
    }

    public void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        TestOutcomes allTestOutcomes = TestOutcomes.of(testOutcomeResults);
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            this.generateReportsFor(reporter, allTestOutcomes);
        }
    }

    private void generateReportsFor(final AcceptanceTestReporter reporter, final TestOutcomes testOutcomes) {
        LOGGER.info("Generating reports using: " + reporter);
        long t0 = System.currentTimeMillis();
        List<? extends TestOutcome> outcomes = testOutcomes.getOutcomes();
        final AtomicInteger remainingReportCount = new AtomicInteger(outcomes.size());
        for (final TestOutcome testOutcome : outcomes) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Processing test outcome " + testOutcome.getCompleteName());
                    ReportService.this.generateReportFor(testOutcome, testOutcomes, reporter);
                    remainingReportCount.decrementAndGet();
                    LOGGER.info("Processing test outcome " + testOutcome.getCompleteName() + " done");
                }
            });
        }
        this.generateJUnitTestResults(testOutcomes);
        this.waitForReportGenerationToFinish(remainingReportCount);
        LOGGER.info("Reports generated in: " + (System.currentTimeMillis() - t0));
    }

    private void generateJUnitTestResults(TestOutcomes outcomes) {
        try {
            this.jUnitXMLOutcomeReporter.generateReportsFor(outcomes);
        }
        catch (IOException e) {
            throw new RuntimeException("Report generation failure", e);
        }
    }

    private void waitForReportGenerationToFinish(AtomicInteger reportCount) {
        while (reportCount.get() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static List<AcceptanceTestReporter> getDefaultReporters() {
        ArrayList<AcceptanceTestReporter> reporters = new ArrayList<AcceptanceTestReporter>();
        FormatConfiguration formatConfiguration = new FormatConfiguration((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
        ServiceLoader<AcceptanceTestReporter> reporterServiceLoader = ServiceLoader.load(AcceptanceTestReporter.class);
        Iterator<AcceptanceTestReporter> reporterImplementations = reporterServiceLoader.iterator();
        LOGGER.info("Reporting formats: " + formatConfiguration.getFormats());
        while (reporterImplementations.hasNext()) {
            AcceptanceTestReporter reporter = reporterImplementations.next();
            LOGGER.info("Found reporter: " + reporter + "(format = " + reporter.getFormat() + ")");
            if (reporter.getFormat().isPresent() && !formatConfiguration.getFormats().contains(reporter.getFormat().get())) continue;
            LOGGER.info("Registering reporter: " + reporter);
            reporters.add(reporter);
        }
        return reporters;
    }

    private void generateReportFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes, AcceptanceTestReporter reporter) {
        try {
            LOGGER.info(reporter + ": Generating report for test outcome: " + testOutcome.getCompleteName());
            reporter.setOutputDirectory(this.outputDirectory);
            reporter.generateReportFor(testOutcome, allTestOutcomes);
        }
        catch (IOException e) {
            throw new ReportGenerationFailedError("Failed to generate reports using " + reporter, e);
        }
    }
}

