/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import com.google.common.base.Optional;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ThucydidesSystemProperty {
    WEBDRIVER_DRIVER,
    DRIVER,
    WEBDRIVER_PROVIDED_TYPE,
    WEBDRIVER_BASE_URL,
    WEBDRIVER_REMOTE_URL,
    PHANTOMJS_WEBDRIVER_PORT,
    WEBDRIVER_REMOTE_DRIVER,
    WEBDRIVER_REMOTE_BROWSER_VERSION,
    WEBDRIVER_REMOTE_OS,
    WEBDRIVER_CHROME_DRIVER,
    THUCYDIDES_PROJECT_KEY,
    THUCYDIDES_PROJECT_NAME,
    THUCYDIDES_HOME,
    THUCYDIDES_REPORT_RESOURCES,
    THUCYDIDES_REPORT_ENCODING,
    THUCYDIDES_OUTPUT_DIRECTORY("thucydides.outputDirectory"),
    THUCYDIDES_ONLY_SAVE_FAILING_SCREENSHOTS,
    THUCYDIDES_DRIVER_CAPABILITIES,
    THUCYDIDES_VERBOSE_SCREENSHOTS,
    THUCYDIDES_VERBOSE_STEPS,
    THUCYDIDES_TAKE_SCREENSHOTS,
    THUCYDIDES_REPORTS_SHOW_STEP_DETAILS,
    THUCYDIDES_REPORT_SHOW_MANUAL_TESTS,
    THUCYDIDES_REPORT_SHOW_RELEASES,
    THUCYDIDES_REPORT_SHOW_PROGRESS,
    THUCYDIDES_REPORT_SHOW_HISTORY,
    THUCYDIDES_REPORT_SHOW_TAG_MENUS,
    THUCYDIDES_RESTART_BROWSER_FREQUENCY,
    THUCYDIDES_STEP_DELAY,
    THUCYDIDES_TIMEOUT,
    REFUSE_UNTRUSTED_CERTIFICATES,
    THUCYDIDES_USE_UNIQUE_BROWSER,
    THUCYDIDES_ESTIMATED_AVERAGE_STEP_COUNT,
    THUCYDIDES_ESTIMATED_TESTS_PER_REQUIREMENT,
    THUCYDIDES_ISSUE_TRACKER_URL,
    THUCYDIDES_NATIVE_EVENTS,
    JIRA_URL,
    JIRA_PROJECT,
    JIRA_USERNAME,
    JIRA_PASSWORD,
    THUCYDIDES_HISTORY,
    THUCYDIDES_BROWSER_HEIGHT,
    THUCYDIDES_BROWSER_WIDTH,
    THUCYDIDES_RESIZED_IMAGE_WIDTH,
    THUCYDIDES_PUBLIC_URL,
    THUCYDIDES_ACTIVATE_FIREBUGS,
    SECURITY_ENABLE_JAVA("security.enable_java"),
    THUCYDIDES_ACTIVATE_HIGHLIGHTING,
    THUCYDIDES_BATCH_STRATEGY,
    THUCYDIDES_BATCH_COUNT,
    THUCYDIDES_BATCH_SIZE,
    THUCYDIDES_BATCH_NUMBER,
    THUCYDIDES_PROXY_HTTP,
    THUCYDIDES_PROXY_HTTP_PORT("thucydides.proxy.http_port"),
    THUCYDIDES_PROXY_TYPE,
    THUCYDIDES_PROXY_USER,
    THUCYDIDES_PROXY_PASSWORD,
    WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT,
    WEBDRIVER_WAIT_FOR_TIMEOUT,
    THUCYDIDES_EXT_PACKAGES,
    CHROME_SWITCHES,
    FIREFOX_PREFERENCES,
    WEBDRIVER_FIREFOX_PROFILE,
    THUCYDIDES_JQUERY_INTEGRATION,
    SAUCELABS_TARGET_PLATFORM,
    SAUCELABS_DRIVER_VERSION,
    SAUCELABS_TEST_NAME,
    SAUCELABS_URL,
    SAUCELABS_ACCESS_KEY,
    SAUCELABS_USER_ID,
    SAUCELABS_IMPLICIT_TIMEOUT,
    SAUCELABS_RECORD_SCREENSHOTS,
    BROWSERSTACK_URL,
    BROWSERSTACK_OS,
    BROWSERSTACK_OS_VERSION,
    BROWSERSTACK_BROWSER,
    BROWSERSTACK_BROWSER_VERSION,
    BROWSERSTACK_DEVICE,
    BROWSERSTACK_DEVICE_ORIENTATION,
    BROWSERSTACK_PROJECT,
    BROWSERSTACK_BUILD,
    BROWSERSTACK_SESSION_NAME,
    BROWSERSTACK_LOCAL,
    BROWSERSTACK_DEBUG,
    BROWSERSTACK_RESOLUTION,
    BROWSERSTACK_SELENIUM_VERSION,
    BROWSERSTACK_IE_NO_FLASH,
    BROWSERSTACK_IE_DRIVER,
    BROWSERSTACK_IE_ENABLE_POPUPS,
    THUCYDIDES_FILE_IO_RETRY_TIMEOUT,
    THUCYDIDES_LOGGING,
    THUCYDIDES_TEST_ROOT,
    THUCYDIDES_REQUIREMENTS_DIR,
    THUCYDIDES_USE_REQUIREMENTS_DIRECTORIES,
    THUCYDIDES_ANNOTATED_REQUIREMENTS_DIR,
    THUCYDIDES_LOWEST_REQUIREMENT_TYPE,
    THUCYDIDES_REQUIREMENT_TYPES,
    THUCYDIDES_REQUIREMENT_EXCLUSIONS,
    THUCYDIDES_RELEASE_TYPES,
    THUCYDIDES_LOCATOR_FACTORY,
    THUCYDIDES_DATA_DIR,
    PROPERTIES,
    THUCYDIDES_TEST_REQUIREMENTS_BASEDIR,
    THUCYDIDES_STORE_HTML_SOURCE,
    THUCYDIDES_KEEP_UNSCALED_SCREENSHOTS,
    TAGS,
    THUCYDIDES_CSV_EXTRA_COLUMNS,
    THUCYDIDES_CONSOLE_HEADINGS,
    NARRATIVE_FORMAT,
    OUTPUT_FORMATS,
    PHANTOMJS_BINARY_PATH,
    IGNORE_EMBEDDED_TABLES,
    SHOW_RELATED_TAGS,
    USE_TEST_CASE_FOR_STORY_TAG,
    SHOW_PIE_CHARTS,
    DASHBOARD_TAG_LIST,
    DASHBOARD_EXCLUDED_TAG_LIST,
    JSON_PRETTY_PRINTING,
    JSON_CHARSET,
    JUNIT_RETRY_TESTS,
    SIMPLIFIED_STACK_TRACES,
    THUCYDIDES_DRY_RUN,
    FEATURE_FILE_LANGUAGE,
    REPORT_THREADS,
    REPORT_MAX_THREADS,
    REPORT_KEEP_ALIVE_TIME,
    DEEP_STEP_EXECUTION_AFTER_FAILURES,
    MANUAL_TEST_REPORT_RESULT,
    THUCYDIDES_MAINTAIN_SESSION;

    private String propertyName;
    public static final int DEFAULT_HEIGHT = 700;
    public static final int DEFAULT_WIDTH = 960;
    private final Logger logger = LoggerFactory.getLogger(ThucydidesSystemProperty.class);

    private ThucydidesSystemProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    private ThucydidesSystemProperty() {
        this.propertyName = this.name().replaceAll("_", ".").toLowerCase();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return this.propertyName;
    }

    public String from(EnvironmentVariables environmentVariables) {
        return this.from(environmentVariables, null);
    }

    private Optional<String> legacyPropertyValueIfPresentIn(EnvironmentVariables environmentVariables) {
        String legacyValue = environmentVariables.getProperty(this.withLegacyPrefix(this.getPropertyName()));
        if (legacyValue != null) {
            this.logger.warn("Legacy property format detected for {}, please use the serenity.* format instead.", (Object)this.getPropertyName());
        }
        return Optional.fromNullable((Object)legacyValue);
    }

    private String withLegacyPrefix(String propertyName) {
        return propertyName.replaceAll("serenity.", "thucydides.");
    }

    private String withSerenityPrefix(String propertyName) {
        return propertyName.replaceAll("thucydides.", "serenity.");
    }

    public String from(EnvironmentVariables environmentVariables, String defaultValue) {
        Optional newPropertyValue = Optional.fromNullable((Object)environmentVariables.getProperty(this.withSerenityPrefix(this.getPropertyName())));
        if (this.isDefined((Optional<String>)newPropertyValue)) {
            return (String)newPropertyValue.get();
        }
        Optional<String> legacyValue = this.legacyPropertyValueIfPresentIn(environmentVariables);
        return this.isDefined(legacyValue) ? (String)legacyValue.get() : defaultValue;
    }

    private boolean isDefined(Optional<String> newPropertyValue) {
        return newPropertyValue.isPresent() && StringUtils.isNotEmpty((CharSequence)((CharSequence)newPropertyValue.get()));
    }

    public int integerFrom(EnvironmentVariables environmentVariables) {
        return this.integerFrom(environmentVariables, 0);
    }

    public int integerFrom(EnvironmentVariables environmentVariables, int defaultValue) {
        Optional newPropertyValue = Optional.fromNullable((Object)environmentVariables.getProperty(this.withSerenityPrefix(this.getPropertyName())));
        if (this.isDefined((Optional<String>)newPropertyValue)) {
            return Integer.valueOf((String)newPropertyValue.get());
        }
        Optional<String> legacyValue = this.legacyPropertyValueIfPresentIn(environmentVariables);
        return this.isDefined(legacyValue) ? Integer.valueOf((String)legacyValue.get()) : defaultValue;
    }

    public Boolean booleanFrom(EnvironmentVariables environmentVariables) {
        return this.booleanFrom(environmentVariables, false);
    }

    public Boolean booleanFrom(EnvironmentVariables environmentVariables, Boolean defaultValue) {
        Optional newPropertyValue = Optional.fromNullable((Object)environmentVariables.getProperty(this.withSerenityPrefix(this.getPropertyName())));
        if (this.isDefined((Optional<String>)newPropertyValue)) {
            return Boolean.valueOf((String)newPropertyValue.get());
        }
        Optional<String> legacyValue = this.legacyPropertyValueIfPresentIn(environmentVariables);
        return this.isDefined(legacyValue) ? Boolean.valueOf((String)legacyValue.get()) : defaultValue;
    }

    public boolean isDefinedIn(EnvironmentVariables environmentVariables) {
        return StringUtils.isNotEmpty((CharSequence)this.from(environmentVariables));
    }
}

