/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.FindsByIosUIAutomation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.pages.DefaultTimeouts;
import net.serenitybdd.core.pages.HtmlTag;
import net.serenitybdd.core.pages.Selectors;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementState;
import net.serenitybdd.core.time.InternalSystemClock;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.locators.MethodTiming;
import net.thucydides.core.annotations.locators.WithConfigurableTimeout;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.jquery.JQueryEnabledPage;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.exceptions.ElementNotFoundAfterTimeoutError;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeDisabledException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeEnabledException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeInvisibleException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBePresentException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeVisibleException;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebElementFacadeImpl
implements WebElementFacade,
net.thucydides.core.pages.WebElementFacade {
    private final WebElement webElement;
    private final WebDriver driver;
    private final long implicitTimeoutInMilliseconds;
    private final long waitForTimeoutInMilliseconds;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 100;
    private final Sleeper sleeper;
    private final Clock webdriverClock;
    private JavascriptExecutorFacade javascriptExecutorFacade;
    private InternalSystemClock clock = new InternalSystemClock();
    private final EnvironmentVariables environmentVariables;
    private ElementLocator locator;
    private WebElement resolvedELement;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebElementFacadeImpl.class);
    private final List<String> HTML_FORM_TAGS = Arrays.asList("input", "button", "select", "textarea", "link", "option");
    private static final List<String> HTML_ELEMENTS_WITH_VALUE_ATTRIBUTE = ImmutableList.of((Object)"input", (Object)"button", (Object)"option");
    private Optional<String> expectedErrorMessage = Optional.absent();

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement webElement, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        this.webElement = webElement;
        this.driver = driver;
        this.locator = locator;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        this.implicitTimeoutInMilliseconds = implicitTimeoutInMilliseconds;
        this.waitForTimeoutInMilliseconds = waitForTimeoutInMilliseconds >= 0L ? waitForTimeoutInMilliseconds : this.defaultWaitForTimeout();
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement webElement, long implicitTimeoutInMilliseconds) {
        this(driver, locator, webElement, implicitTimeoutInMilliseconds, implicitTimeoutInMilliseconds);
    }

    private long defaultWaitForTimeout() {
        return ThucydidesSystemProperty.WEBDRIVER_WAIT_FOR_TIMEOUT.integerFrom(this.environmentVariables, (int)DefaultTimeouts.DEFAULT_WAIT_FOR_TIMEOUT.in(TimeUnit.MILLISECONDS));
    }

    private WebElementFacadeImpl copy() {
        return new WebElementFacadeImpl(this.driver, this.locator, this.webElement, this.implicitTimeoutInMilliseconds, this.waitForTimeoutInMilliseconds);
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, long implicitTimeoutInMilliseconds) {
        this(driver, locator, null, implicitTimeoutInMilliseconds, implicitTimeoutInMilliseconds);
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        this(driver, locator, null, implicitTimeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public static <T extends WebElementFacade> T wrapWebElement(WebDriver driver, WebElement element, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        return (T)new WebElementFacadeImpl(driver, null, element, timeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public static <T extends WebElementFacade> T wrapWebElement(WebDriver driver, WebElement element, long timeout) {
        return (T)new WebElementFacadeImpl(driver, null, element, timeout, timeout);
    }

    protected WebElement getElement() {
        WebElement result;
        if (this.resolvedElement() != null) {
            result = this.resolvedElement();
        } else if (this.locator == null) {
            result = null;
        } else {
            this.resolvedELement = this.getLocator().findElement();
            if (this.resolvedELement == null) {
                throw new ElementNotVisibleException(this.locator.toString());
            }
            result = this.resolvedELement;
        }
        return result;
    }

    private WebElement resolvedElement() {
        return this.webElement != null ? this.webElement : this.resolvedELement;
    }

    protected JavascriptExecutorFacade getJavascriptExecutorFacade() {
        return this.javascriptExecutorFacade;
    }

    protected InternalSystemClock getClock() {
        return this.clock;
    }

    public WebElementFacade then(String xpathOrCssSelector) {
        return this.findBy(xpathOrCssSelector);
    }

    @Override
    public <T extends WebElementFacade> T findBy(String xpathOrCssSelector) {
        this.logIfVerbose("findBy " + xpathOrCssSelector);
        WebElement nestedElement = Selectors.isXPath(xpathOrCssSelector) ? this.getElement().findElement(By.xpath((String)xpathOrCssSelector)) : this.getElement().findElement(By.cssSelector((String)xpathOrCssSelector));
        return WebElementFacadeImpl.wrapWebElement(this.driver, nestedElement, this.timeoutInMilliseconds(), this.waitForTimeoutInMilliseconds);
    }

    public long timeoutInMilliseconds() {
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).getCurrentImplicitTimeout().in(TimeUnit.MILLISECONDS);
        }
        return this.implicitTimeoutInMilliseconds;
    }

    @Override
    public List<WebElementFacade> thenFindAll(String xpathOrCssSelector) {
        this.logIfVerbose("findAll " + xpathOrCssSelector);
        List<WebElement> nestedElements = Selectors.isXPath(xpathOrCssSelector) ? this.findElements(By.xpath((String)xpathOrCssSelector)) : this.findElements(By.cssSelector((String)xpathOrCssSelector));
        return this.webElementFacadesFrom(nestedElements);
    }

    private List<WebElementFacade> webElementFacadesFrom(List<WebElement> nestedElements) {
        ArrayList results = Lists.newArrayList();
        for (WebElement element : nestedElements) {
            results.add(WebElementFacadeImpl.wrapWebElement(this.driver, element, this.timeoutInMilliseconds(), this.waitForTimeoutInMilliseconds));
        }
        return results;
    }

    public WebElementFacade findBy(By selector) {
        this.logIfVerbose("findBy " + selector);
        WebElement nestedElement = this.getElement().findElement(selector);
        return WebElementFacadeImpl.wrapWebElement(this.driver, nestedElement, this.timeoutInMilliseconds(), this.waitForTimeoutInMilliseconds);
    }

    public WebElementFacade find(By bySelector) {
        return this.findBy(bySelector);
    }

    public WebElementFacade then(By bySelector) {
        return this.findBy(bySelector);
    }

    @Override
    public String getAttribute(String name) {
        return this.getElement().getAttribute(name);
    }

    @Override
    public List<WebElementFacade> thenFindAll(By selector) {
        this.logIfVerbose("findAll " + selector);
        List<WebElement> nestedElements = this.findElements(selector);
        return this.webElementFacadesFrom(nestedElements);
    }

    public WebElement findElementByAccessibilityId(String id) {
        return ((FindsByAccessibilityId)this.getElement()).findElementByAccessibilityId(id);
    }

    public List<WebElement> findElementsByAccessibilityId(String id) {
        return ((FindsByAccessibilityId)this.getElement()).findElementsByAccessibilityId(id);
    }

    public WebElement findElementByAndroidUIAutomator(String using) {
        return ((FindsByAndroidUIAutomator)this.getElement()).findElementByAndroidUIAutomator(using);
    }

    public List<WebElement> findElementsByAndroidUIAutomator(String using) {
        return ((FindsByAndroidUIAutomator)this.getElement()).findElementsByAndroidUIAutomator(using);
    }

    public WebElement findElementByIosUIAutomation(String using) {
        return ((FindsByIosUIAutomation)this.getElement()).findElementByIosUIAutomation(using);
    }

    public List<WebElement> findElementsByIosUIAutomation(String using) {
        return ((FindsByIosUIAutomation)this.getElement()).findElementsByIosUIAutomation(using);
    }

    @Override
    public long getImplicitTimeoutInMilliseconds() {
        return this.implicitTimeoutInMilliseconds;
    }

    public Duration getImplicitTimeout() {
        return ((ConfigurableTimeouts)this.driver).getCurrentImplicitTimeout();
    }

    public WebElementFacade withTimeoutOf(int timeout, TimeUnit unit) {
        return WebElementFacadeImpl.wrapWebElement(this.driver, this.getElement(), this.implicitTimeoutInMilliseconds, TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    @Override
    public boolean isVisible() {
        try {
            WebElement element = this.getElement();
            return element != null && element.isDisplayed();
        }
        catch (ElementNotVisibleException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    public WebElementFacade and() {
        return this;
    }

    public WebElementFacade then() {
        return this;
    }

    @Override
    public boolean isCurrentlyVisible() {
        return this.isVisible();
    }

    @Override
    public boolean isCurrentlyEnabled() {
        try {
            return this.getElement().isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    @Override
    public void shouldBeVisible() {
        if (!this.isVisible()) {
            this.failWithMessage("Element should be visible");
        }
    }

    @Override
    public void shouldBeCurrentlyVisible() {
        if (!this.isCurrentlyVisible()) {
            this.failWithMessage("Element should be visible");
        }
    }

    @Override
    public void shouldNotBeVisible() {
        if (this.isCurrentlyVisible()) {
            this.failWithMessage("Element should not be visible");
        }
    }

    @Override
    public void shouldNotBeCurrentlyVisible() {
        if (this.isCurrentlyVisible()) {
            this.failWithMessage("Element should not be visible");
        }
    }

    @Override
    public boolean hasFocus() {
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        WebElement activeElement = (WebElement)js.executeScript("return window.document.activeElement");
        return this.getElement().equals(activeElement);
    }

    @Override
    public boolean containsText(String value) {
        WebElement element = this.getElement();
        return element != null && element.getText().contains(value);
    }

    @Override
    public boolean containsOnlyText(String value) {
        WebElement element = this.getElement();
        return element != null && element.getText().equals(value);
    }

    @Override
    public boolean containsSelectOption(String value) {
        return this.getSelectOptions().contains(value);
    }

    @Override
    public List<String> getSelectOptions() {
        List<Object> results = Collections.emptyList();
        if (this.getElement() != null) {
            results = this.findElements(By.tagName((String)"option"));
        }
        return Lambda.convert(results, (Converter)new ExtractText());
    }

    public ElementLocator getLocator() {
        if (this.locator instanceof WithConfigurableTimeout && this.driver instanceof ConfigurableTimeouts) {
            ((WithConfigurableTimeout)this.locator).setTimeOutInSeconds((int)this.getLocatorTimeout());
        }
        return this.locator;
    }

    private long getLocatorTimeout() {
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed() || MethodTiming.forThisThread().isInQuickMethod()) {
            return 0L;
        }
        return TimeUnit.SECONDS.convert(this.implicitTimeoutInMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setImplicitTimeout(Duration implicitTimeout) {
        if (this.driver instanceof ConfigurableTimeouts) {
            ((ConfigurableTimeouts)this.driver).setImplicitTimeout(implicitTimeout);
        }
    }

    @Override
    public Duration getCurrentImplicitTimeout() {
        if (this.driver instanceof ConfigurableTimeouts) {
            return ((ConfigurableTimeouts)this.driver).getCurrentImplicitTimeout();
        }
        return DefaultTimeouts.DEFAULT_IMPLICIT_WAIT_TIMEOUT;
    }

    @Override
    public void resetTimeouts() {
        if (this.driver instanceof ConfigurableTimeouts) {
            ((ConfigurableTimeouts)this.driver).resetTimeouts();
        }
    }

    @Override
    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element. Element text '%s'.", textValue, this.getElement().getText());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldContainOnlyText(String textValue) {
        if (!this.containsOnlyText(textValue)) {
            String errorMessage = String.format("The text '%s' does not match the elements text '%s'.", textValue, this.getElement().getText());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldContainSelectedOption(String textValue) {
        if (!this.containsSelectOption(textValue)) {
            String errorMessage = String.format("The list element '%s' was not found in the web element", textValue);
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldNotContainText(String textValue) {
        if (this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was found in the web element when it should not have. Element text '%s'.", textValue, this.getElement().getText());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldBeEnabled() {
        if (!this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should be enabled", this.toString());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getElement() != null && this.getElement().isEnabled();
    }

    @Override
    public void shouldNotBeEnabled() {
        if (this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should not be enabled", this.toString());
            this.failWithMessage(errorMessage);
        }
    }

    public WebElementFacade type(String value) {
        this.logIfVerbose("Type '" + value + "'");
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.clear();
        this.getElement().sendKeys(new CharSequence[]{value});
        this.notifyScreenChange();
        return this;
    }

    public WebElementFacade typeAndEnter(String value) {
        this.logIfVerbose("Type and enter '" + value + "'");
        this.waitUntilElementAvailable();
        this.clear();
        this.getElement().sendKeys(new CharSequence[]{value, Keys.ENTER});
        this.notifyScreenChange();
        return this;
    }

    public WebElementFacade typeAndTab(String value) {
        this.logIfVerbose("Type and tab '" + value + "'");
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.clear();
        this.getElement().sendKeys(new CharSequence[]{value});
        this.getElement().sendKeys(new CharSequence[]{Keys.TAB});
        this.getClock().pauseFor(100L);
        this.notifyScreenChange();
        return this;
    }

    @Override
    public void setWindowFocus() {
        this.getJavascriptExecutorFacade().executeScript("window.focus()");
    }

    public WebElementFacade selectByVisibleText(String label) {
        this.logIfVerbose("Select label '" + label + "'");
        this.waitUntilElementAvailable();
        Select select = new Select(this.getElement());
        select.selectByVisibleText(label);
        this.notifyScreenChange();
        return this;
    }

    @Override
    public String getSelectedVisibleTextValue() {
        this.waitUntilVisible();
        Select select = new Select(this.getElement());
        return select.getFirstSelectedOption().getText();
    }

    public WebElementFacade selectByValue(String value) {
        this.logIfVerbose("Select value '" + value + "'");
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        Select select = new Select(this.getElement());
        select.selectByValue(value);
        this.notifyScreenChange();
        return this;
    }

    @Override
    public String getSelectedValue() {
        this.waitUntilVisible();
        Select select = new Select(this.getElement());
        return select.getFirstSelectedOption().getAttribute("value");
    }

    public WebElementFacade selectByIndex(int indexValue) {
        this.logIfVerbose("Select by index '" + indexValue + "'");
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        Select select = new Select(this.getElement());
        select.selectByIndex(indexValue);
        this.notifyScreenChange();
        return this;
    }

    private void waitUntilElementAvailable() {
        if (this.driverIsDisabled()) {
            return;
        }
        this.withTimeoutOf((int)this.waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS).waitUntilEnabled();
    }

    private boolean driverIsDisabled() {
        return StepEventBus.getEventBus().webdriverCallsAreSuspended();
    }

    @Override
    public boolean isPresent() {
        if (this.driverIsDisabled()) {
            return false;
        }
        try {
            WebElement element = this.getElement();
            if (element == null) {
                return false;
            }
            element.isDisplayed();
            return true;
        }
        catch (ElementNotVisibleException e) {
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ElementNotFoundAfterTimeoutError timeoutError) {
            return false;
        }
    }

    @Override
    public void shouldBePresent() {
        if (!this.isPresent()) {
            this.failWithMessage("Field should be present");
        }
    }

    @Override
    public void shouldNotBePresent() {
        if (this.isPresent()) {
            this.failWithMessage("Field should not be present");
        }
    }

    private void failWithMessage(String errorMessage) {
        throw new AssertionError((Object)this.getErrorMessage(errorMessage));
    }

    private void checkPresenceOfWebElement() {
        try {
            if (!this.driverIsDisabled()) {
                this.waitForCondition().until(this.elementIsDisplayed());
            }
        }
        catch (Throwable error) {
            if (this.webElement != null) {
                this.throwShouldBeVisibleErrorWithCauseIfPresent(error, error.getMessage());
            }
            this.throwNoSuchElementExceptionWithCauseIfPresent(error, error.getMessage());
        }
    }

    public WebElementFacade waitUntilVisible() {
        try {
            if (!this.driverIsDisabled()) {
                this.waitForCondition().until(this.elementIsDisplayed());
            }
        }
        catch (Throwable error) {
            if (this.webElement != null) {
                this.throwShouldBeVisibleErrorWithCauseIfPresent(error, error.getMessage());
            }
            this.throwNoSuchElementExceptionWithCauseIfPresent(error, error.getMessage());
        }
        return this;
    }

    public WebElementFacade waitUntilPresent() {
        try {
            if (!this.driverIsDisabled()) {
                this.waitForCondition().until(this.elementIsPresent());
            }
        }
        catch (TimeoutException timeout) {
            this.throwShouldBePresentErrorWithCauseIfPresent(timeout, timeout.getMessage());
        }
        return this;
    }

    private void throwNoSuchElementExceptionWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new NoSuchElementException(finalMessage, timeout);
    }

    private void throwShouldBeVisibleErrorWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new ElementShouldBeVisibleException(finalMessage, timeout);
    }

    private void throwShouldBeInvisibleErrorWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new ElementShouldBeInvisibleException(finalMessage, timeout);
    }

    private void throwShouldBePresentErrorWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new ElementShouldBePresentException(finalMessage, timeout);
    }

    private ExpectedCondition<Boolean> elementIsDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacadeImpl.this.isCurrentlyVisible();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsPresent() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacadeImpl.this.isPresent();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsNotDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !WebElementFacadeImpl.this.isCurrentlyVisible();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement element = WebElementFacadeImpl.this.getElement();
                return element != null && !WebElementFacadeImpl.this.isDisabledField(element);
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsClickable() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement element = WebElementFacadeImpl.this.getElement();
                return element != null && element.isDisplayed() && element.isEnabled();
            }
        };
    }

    private boolean isDisabledField(WebElement webElement) {
        return this.isAFormElement(webElement) && !webElement.isEnabled();
    }

    private boolean isAFormElement(WebElement webElement) {
        if (webElement == null || webElement.getTagName() == null) {
            return false;
        }
        String tag = webElement.getTagName().toLowerCase();
        return this.HTML_FORM_TAGS.contains(tag);
    }

    private boolean hasValueAttribute(WebElement webElement) {
        String tag = webElement.getTagName().toLowerCase();
        return HTML_ELEMENTS_WITH_VALUE_ATTRIBUTE.contains(tag);
    }

    private ExpectedCondition<Boolean> elementIsNotEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacadeImpl.this.getElement() != null && !WebElementFacadeImpl.this.getElement().isEnabled();
            }

            public String toString() {
                return "Element is not enabled: " + WebElementFacadeImpl.this.getElement();
            }
        };
    }

    @Override
    public Wait<WebDriver> waitForCondition() {
        return new FluentWait((Object)this.driver, this.webdriverClock, this.sleeper).withTimeout(this.waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    private Wait<WebDriver> waitBriefly() {
        return new FluentWait((Object)this.driver, this.webdriverClock, this.sleeper).withTimeout(500L, TimeUnit.MILLISECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public WebElementFacade waitUntilNotVisible() {
        try {
            if (!this.driverIsDisabled()) {
                this.waitForCondition().until(this.elementIsNotDisplayed());
            }
        }
        catch (TimeoutException timeout) {
            this.throwShouldBeInvisibleErrorWithCauseIfPresent(timeout, "Expected hidden element was displayed");
        }
        return this;
    }

    @Override
    public String getValue() {
        this.checkPresenceOfWebElement();
        return this.getElement().getAttribute("value");
    }

    @Override
    public boolean isSelected() {
        this.waitUntilVisible();
        return this.getElement().isSelected();
    }

    @Override
    public String getText() {
        this.checkPresenceOfWebElement();
        return this.getElement().getText();
    }

    public WebElementFacade waitUntilEnabled() {
        try {
            if (!this.driverIsDisabled()) {
                this.waitForCondition().until(this.elementIsEnabled());
            }
        }
        catch (TimeoutException timeout) {
            throw new ElementShouldBeEnabledException("Expected enabled element was not enabled", timeout);
        }
        return this;
    }

    public WebElementFacade waitUntilClickable() {
        try {
            if (!this.driverIsDisabled()) {
                this.waitForCondition().until(this.elementIsClickable());
            }
        }
        catch (TimeoutException timeout) {
            throw new ElementShouldBeEnabledException("Expected enabled element was not enabled", timeout);
        }
        return this;
    }

    public WebElementFacade waitUntilDisabled() {
        try {
            if (!this.driverIsDisabled()) {
                this.waitForCondition().until(this.elementIsNotEnabled());
            }
        }
        catch (TimeoutException timeout) {
            throw new ElementShouldBeDisabledException("Expected disabled element was not disabled", timeout);
        }
        return this;
    }

    @Override
    public String getTextValue() {
        this.waitUntilPresent();
        if (!this.isVisible()) {
            return "";
        }
        if (this.valueAttributeSupportedAndDefinedIn(this.getElement())) {
            return this.getValue();
        }
        if (!StringUtils.isEmpty((CharSequence)this.getElement().getText())) {
            return this.getElement().getText();
        }
        return "";
    }

    @Override
    public WebElementState expect(String errorMessage) {
        return this.copy().expectingErrorMessage(errorMessage);
    }

    protected WebElementState expectingErrorMessage(String errorMessage) {
        this.expectedErrorMessage = Optional.of((Object)errorMessage);
        return this;
    }

    protected String getErrorMessage(String defaultErrorMessage) {
        return (String)this.expectedErrorMessage.or((Object)defaultErrorMessage);
    }

    private boolean valueAttributeSupportedAndDefinedIn(WebElement webElement) {
        return this.hasValueAttribute(webElement) && StringUtils.isNotEmpty((CharSequence)this.getValue());
    }

    @Override
    public void click() {
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.logClick();
        this.getElement().click();
        this.notifyScreenChange();
    }

    private void logClick() {
        this.logIfVerbose("click");
    }

    private void logIfVerbose(String logMessage) {
        if (this.useVerboseLogging()) {
            LOGGER.info(this.humanizedTabfNameFor(this.getElement()) + ":" + logMessage);
        }
    }

    private boolean useVerboseLogging() {
        return ThucydidesSystemProperty.THUCYDIDES_VERBOSE_STEPS.booleanFrom(this.environmentVariables);
    }

    private EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    private String humanizedTabfNameFor(WebElement webElement) {
        return HtmlTag.from(webElement).inHumanReadableForm();
    }

    private boolean isMobileDriver() {
        return ThucydidesWebDriverSupport.getDriverClass() == AppiumDriver.class;
    }

    @Override
    public void clear() {
        if (!this.isMobileDriver()) {
            this.getElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), Keys.DELETE});
        }
        this.getElement().clear();
    }

    private void enableHighlightingIfRequired() {
        JQueryEnabledPage jQueryEnabledPage = JQueryEnabledPage.withDriver(this.driver);
        if (jQueryEnabledPage.isJQueryIntegrationEnabled() && !jQueryEnabledPage.isJQueryAvailable()) {
            jQueryEnabledPage.injectJQueryPlugins();
        }
    }

    private void notifyScreenChange() {
        StepEventBus.getEventBus().notifyScreenChange();
    }

    @Override
    public String toString() {
        String locatorString = this.locator != null ? this.locator.toString() : "<Undefined web element>";
        return this.resolvedElement() != null ? this.resolvedElement().toString() : locatorString;
    }

    public void submit() {
        this.getElement().submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.getElement().sendKeys(keysToSend);
    }

    public String getTagName() {
        return this.getElement().getTagName();
    }

    private Optional<WebDriverFacade> webDriverFacade() {
        if (this.driver instanceof WebElementFacade) {
            return Optional.of((Object)((WebDriverFacade)this.driver));
        }
        return Optional.absent();
    }

    public List<WebElement> findElements(By by) {
        return this.getElement().findElements(by);
    }

    public WebElement findElement(By by) {
        return this.getElement().findElement(by);
    }

    public boolean isDisplayed() {
        return this.getElement().isDisplayed();
    }

    public Point getLocation() {
        return this.getElement().getLocation();
    }

    public Dimension getSize() {
        return this.getElement().getSize();
    }

    public String getCssValue(String propertyName) {
        return this.getElement().getCssValue(propertyName);
    }

    public WebElement getWrappedElement() {
        return this.getElement();
    }

    public Coordinates getCoordinates() {
        return ((Locatable)this.getElement()).getCoordinates();
    }

    @Override
    public boolean containsElements(By bySelector) {
        return !this.findElements(bySelector).isEmpty();
    }

    @Override
    public boolean containsElements(String xpathOrCssSelector) {
        return !this.thenFindAll(xpathOrCssSelector).isEmpty();
    }

    @Override
    public void shouldContainElements(By bySelector) {
        if (!this.containsElements(bySelector)) {
            String errorMessage = String.format("Could not find contained elements %s in %s", bySelector, this.getElement().toString());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldContainElements(String xpathOrCssSelector) {
        if (!this.containsElements(xpathOrCssSelector)) {
            String errorMessage = String.format("Could not find contained elements %s in %s", xpathOrCssSelector, this.getElement().toString());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public boolean hasClass(String cssClassName) {
        String cssClassValue = this.getAttribute("class").toLowerCase();
        ArrayList cssClasses = Lists.newArrayList((Iterable)Splitter.on((String)" ").omitEmptyStrings().trimResults().split((CharSequence)cssClassValue));
        return cssClasses.contains(cssClassName.toLowerCase());
    }

    class ExtractText
    implements Converter<WebElement, String> {
        ExtractText() {
        }

        public String convert(WebElement from) {
            return from.getText();
        }
    }
}

