/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.strategies;

import com.google.common.base.Splitter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.capabilities.BrowserStackRemoteDriverCapabilities;
import net.thucydides.core.webdriver.capabilities.SauceRemoteDriverCapabilities;
import net.thucydides.core.webdriver.strategies.DriverBuilder;
import net.thucydides.core.webdriver.strategies.DriverCapabilities;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;

public class RemoteDriverBuilder
implements DriverBuilder {
    private final EnvironmentVariables environmentVariables;
    private final CapabilityEnhancer enhancer;
    private final DriverCapabilityRecord driverProperties;
    private final BrowserStackRemoteDriverCapabilities browserStackRemoteDriverCapabilities;
    private final SauceRemoteDriverCapabilities sauceRemoteDriverCapabilities;
    private final DriverCapabilities remoteDriverCapabilities;

    public RemoteDriverBuilder(EnvironmentVariables environmentVariables, CapabilityEnhancer enhancer) {
        this.environmentVariables = environmentVariables;
        this.enhancer = enhancer;
        this.driverProperties = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
        this.browserStackRemoteDriverCapabilities = new BrowserStackRemoteDriverCapabilities(environmentVariables);
        this.sauceRemoteDriverCapabilities = new SauceRemoteDriverCapabilities(environmentVariables);
        this.remoteDriverCapabilities = new DriverCapabilities(environmentVariables, enhancer);
    }

    @Override
    public WebDriver newInstance() throws MalformedURLException {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        WebDriver driver = this.saucelabsUrlIsDefined() ? this.buildSaucelabsDriver() : (this.browserStackUrlIsDefined() ? this.buildBrowserStackDriver() : this.buildRemoteDriver());
        Augmenter augmenter = new Augmenter();
        return augmenter.augment(driver);
    }

    private boolean saucelabsUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.sauceRemoteDriverCapabilities.getUrl());
    }

    private boolean browserStackUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.browserStackRemoteDriverCapabilities.getUrl());
    }

    private WebDriver buildSaucelabsDriver() throws MalformedURLException {
        String saucelabsUrl = this.sauceRemoteDriverCapabilities.getUrl();
        WebDriver driver = this.newRemoteDriver(new URL(saucelabsUrl), this.findSaucelabsCapabilities());
        if (StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.from(this.environmentVariables))) {
            int implicitWait = ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.integerFrom(this.environmentVariables, 30);
            driver.manage().timeouts().implicitlyWait((long)implicitWait, TimeUnit.SECONDS);
        }
        return driver;
    }

    private WebDriver buildBrowserStackDriver() throws MalformedURLException {
        String browserStackUrl = this.browserStackRemoteDriverCapabilities.getUrl();
        WebDriver driver = this.newRemoteDriver(new URL(browserStackUrl), this.findbrowserStackCapabilities());
        return driver;
    }

    private WebDriver buildRemoteDriver() throws MalformedURLException {
        String remoteUrl = ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.from(this.environmentVariables);
        return this.newRemoteDriver(new URL(remoteUrl), this.buildRemoteCapabilities());
    }

    private Capabilities findSaucelabsCapabilities() {
        String driver = WebDriverFactory.getDriverFrom(this.environmentVariables);
        DesiredCapabilities capabilities = this.remoteDriverCapabilities.forDriver(driver);
        return this.sauceRemoteDriverCapabilities.getCapabilities(capabilities);
    }

    private Capabilities findbrowserStackCapabilities() {
        String driver = WebDriverFactory.getDriverFrom(this.environmentVariables);
        DesiredCapabilities capabilities = this.remoteDriverCapabilities.forDriver(driver);
        return this.browserStackRemoteDriverCapabilities.getCapabilities(capabilities);
    }

    private Capabilities buildRemoteCapabilities() {
        String driver = ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.from(this.environmentVariables);
        if (driver == null) {
            driver = WebDriverFactory.getDriverFrom(this.environmentVariables);
        }
        return this.remoteDriverCapabilities.forDriver(driver);
    }

    public WebDriver newRemoteDriver(URL remoteUrl, Capabilities capabilities) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        try {
            this.ensureHostIsAvailableAt(remoteUrl);
            RemoteWebDriver driver = new RemoteWebDriver(remoteUrl, capabilities);
            this.driverProperties.registerCapabilities("remote", driver.getCapabilities());
            return driver;
        }
        catch (UnreachableBrowserException unreachableBrowser) {
            String errorMessage = this.unreachableBrowserErrorMessage((Exception)((Object)unreachableBrowser));
            throw new SerenityManagedException(errorMessage, unreachableBrowser);
        }
        catch (UnknownHostException unknownHost) {
            throw new SerenityManagedException(unknownHost.getMessage(), unknownHost);
        }
    }

    private void ensureHostIsAvailableAt(URL remoteUrl) throws UnknownHostException {
        InetAddress.getByName(remoteUrl.getHost());
    }

    private String unreachableBrowserErrorMessage(Exception unreachableBrowser) {
        List errorLines = Splitter.onPattern((String)"\n").splitToList((CharSequence)unreachableBrowser.getLocalizedMessage());
        Throwable cause = unreachableBrowser.getCause();
        String errorCause = cause == null ? "" : System.lineSeparator() + cause.getClass().getSimpleName() + " - " + cause.getLocalizedMessage();
        return (String)errorLines.get(0) + errorCause;
    }
}

