/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.strategies;

import java.io.IOException;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.phantomjs.PhantomJSCapabilityEnhancer;
import net.thucydides.core.webdriver.strategies.DriverBuilder;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSDriverBuilder
implements DriverBuilder {
    private final EnvironmentVariables environmentVariables;
    private final CapabilityEnhancer defaultCapabilitiyEnhancer;
    private final DriverCapabilityRecord driverProperties;

    public PhantomJSDriverBuilder(EnvironmentVariables environmentVariables, CapabilityEnhancer enhancer) {
        this.environmentVariables = environmentVariables;
        this.defaultCapabilitiyEnhancer = enhancer;
        this.driverProperties = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance() {
        DesiredCapabilities capabilities = DesiredCapabilities.phantomjs();
        PhantomJSCapabilityEnhancer enhancer = new PhantomJSCapabilityEnhancer(this.environmentVariables);
        enhancer.enhanceCapabilities(capabilities);
        PhantomJSDriver driver = new PhantomJSDriver((Capabilities)this.defaultCapabilitiyEnhancer.enhanced(capabilities));
        this.driverProperties.registerCapabilities("phantomjs", driver.getCapabilities());
        return driver;
    }

    private void setPhantomJSPathIfNotSet() {
        if (!this.phantomJSIsAvailable()) {
            String phantomJSPath = this.environmentVariables.getProperty("phantomjs.binary.path");
            String phantomJSPathEnvironmentProperty = System.getenv("PHANTOMJS_BINARY_PATH");
            if (StringUtils.isNotEmpty((CharSequence)phantomJSPath)) {
                System.setProperty("phantomjs.binary.path", phantomJSPath);
            } else if (StringUtils.isNotEmpty((CharSequence)phantomJSPathEnvironmentProperty)) {
                System.setProperty("phantomjs.binary.path", phantomJSPathEnvironmentProperty);
            }
        }
    }

    private boolean phantomJSIsAvailable() {
        try {
            return this.executeCommand("phantomjs -v") != 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private int executeCommand(String command) throws IOException {
        Process cmdProc = Runtime.getRuntime().exec(command);
        try {
            return cmdProc.waitFor();
        }
        catch (InterruptedException e) {
            return -1;
        }
    }
}

