/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.strategies;

import java.io.File;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.firefox.FirefoxProfileEnhancer;
import net.thucydides.core.webdriver.strategies.DriverCapabilitiesProvider;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxDriverCapabilities
implements DriverCapabilitiesProvider {
    private final EnvironmentVariables environmentVariables;
    private final FirefoxProfileEnhancer firefoxProfileEnhancer;
    private ProfilesIni allProfiles;

    public FirefoxDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.firefoxProfileEnhancer = new FirefoxProfileEnhancer(environmentVariables);
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.firefox();
        capabilities.setCapability("firefox_profile", (Object)this.buildFirefoxProfile());
        return capabilities;
    }

    protected FirefoxProfile buildFirefoxProfile() {
        String profileName = ThucydidesSystemProperty.WEBDRIVER_FIREFOX_PROFILE.from(this.environmentVariables);
        FilePathParser parser = new FilePathParser(this.environmentVariables);
        DesiredCapabilities firefoxCapabilities = DesiredCapabilities.firefox();
        if (StringUtils.isNotEmpty((CharSequence)profileName)) {
            firefoxCapabilities.setCapability("firefox_profile", parser.getInstanciatedPath(profileName));
        }
        FirefoxProfile profile = profileName == null ? this.createNewFirefoxProfile() : this.getProfileFrom(profileName);
        this.firefoxProfileEnhancer.allowWindowResizeFor(profile);
        this.firefoxProfileEnhancer.activateNativeEventsFor(profile, this.shouldEnableNativeEvents());
        if (this.shouldActivateProxy()) {
            this.activateProxyFor(profile, this.firefoxProfileEnhancer);
        }
        if (this.firefoxProfileEnhancer.shouldActivateFirebugs()) {
            this.firefoxProfileEnhancer.addFirebugsTo(profile);
        }
        if (this.refuseUntrustedCertificates()) {
            profile.setAssumeUntrustedCertificateIssuer(false);
            profile.setAcceptUntrustedCertificates(false);
        } else {
            profile.setAssumeUntrustedCertificateIssuer(true);
            profile.setAcceptUntrustedCertificates(true);
        }
        this.firefoxProfileEnhancer.configureJavaSupport(profile);
        this.firefoxProfileEnhancer.addPreferences(profile);
        return profile;
    }

    private boolean shouldEnableNativeEvents() {
        return Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_NATIVE_EVENTS.from(this.environmentVariables, "true"));
    }

    private void activateProxyFor(FirefoxProfile profile, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        String proxyPort = this.getProxyPortFromEnvironmentVariables();
        firefoxProfileEnhancer.activateProxy(profile, proxyUrl, proxyPort);
    }

    private String getProxyPortFromEnvironmentVariables() {
        return ThucydidesSystemProperty.THUCYDIDES_PROXY_HTTP_PORT.from(this.environmentVariables);
    }

    private boolean shouldActivateProxy() {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        return StringUtils.isNotEmpty((CharSequence)proxyUrl);
    }

    private String getProxyUrlFromEnvironmentVariables() {
        return ThucydidesSystemProperty.THUCYDIDES_PROXY_HTTP.from(this.environmentVariables);
    }

    private FirefoxProfile getProfileFrom(String profileName) {
        FirefoxProfile profile = this.getAllProfiles().getProfile(profileName);
        if (profile == null) {
            profile = this.useExistingFirefoxProfile(new File(profileName));
        }
        return profile;
    }

    protected ProfilesIni getAllProfiles() {
        if (this.allProfiles == null) {
            this.allProfiles = new ProfilesIni();
        }
        return this.allProfiles;
    }

    protected FirefoxProfile createNewFirefoxProfile() {
        FirefoxProfile profile;
        if (Serenity.getFirefoxProfile() != null) {
            profile = Serenity.getFirefoxProfile();
        } else {
            profile = new FirefoxProfile();
            profile.setPreference("network.proxy.socks_port", 9999);
            profile.setAlwaysLoadNoFocusLib(true);
            profile.setEnableNativeEvents(true);
        }
        return profile;
    }

    protected FirefoxProfile useExistingFirefoxProfile(File profileDirectory) {
        return new FirefoxProfile(profileDirectory);
    }

    private boolean refuseUntrustedCertificates() {
        return ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.booleanFrom(this.environmentVariables);
    }
}

