/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.List;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverContext;
import net.thucydides.core.webdriver.WebdriverInstances;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public class SerenityWebdriverManager
implements WebdriverManager {
    private static final ThreadLocal<WebdriverInstances> webdriverInstancesThreadLocal = new ThreadLocal();
    private final WebDriverFactory webDriverFactory;
    private final Configuration configuration;
    private Optional<String> overridenDefaultDriverType = Optional.absent();

    @Inject
    public SerenityWebdriverManager(WebDriverFactory webDriverFactory, Configuration configuration) {
        this.webDriverFactory = webDriverFactory;
        this.configuration = configuration;
    }

    private static WebDriver newDriver(Configuration configuration, WebDriverFactory webDriverFactory, String driver) {
        SupportedWebDriver supportedDriverType = SerenityWebdriverManager.getConfiguredWebDriverWithOverride(configuration, driver);
        Class<? extends WebDriver> webDriverType = webDriverFactory.getClassFor(supportedDriverType);
        return WebdriverProxyFactory.getFactory().proxyFor(webDriverType, webDriverFactory, configuration);
    }

    private static SupportedWebDriver getConfiguredWebDriverWithOverride(Configuration configuration, String driver) {
        if (StringUtils.isEmpty((CharSequence)driver)) {
            return configuration.getDriverType();
        }
        return SupportedWebDriver.getDriverTypeFor(driver);
    }

    @Override
    public void closeDriver() {
        SerenityWebdriverManager.inThisTestThread().closeCurrentDriver();
    }

    @Override
    public void closeAllDrivers() {
        SerenityWebdriverManager.inThisTestThread().closeAllDrivers();
    }

    @Override
    public void reset() {
        SerenityWebdriverManager.inThisTestThread().closeAllDrivers();
    }

    @Override
    public void resetDriver() {
        SerenityWebdriverManager.inThisTestThread().resetCurrentDriver();
    }

    @Override
    public WebDriver getWebdriver() {
        String currentDriverName = StringUtils.isNotEmpty((CharSequence)SerenityWebdriverManager.inThisTestThread().getCurrentDriverName()) ? SerenityWebdriverManager.inThisTestThread().getCurrentDriverName() : this.getDefaultDriverType();
        return SerenityWebdriverManager.instantiatedThreadLocalWebDriver(this.configuration, this.webDriverFactory, currentDriverName);
    }

    @Override
    public WebdriverContext inContext(String context) {
        return new WebdriverContext(this, context);
    }

    @Override
    public void setCurrentDriver(WebDriver driver) {
        SerenityWebdriverManager.inThisTestThread().setCurrentDriverTo(driver);
    }

    @Override
    public void clearCurrentDriver() {
    }

    @Override
    public void registerDriver(WebDriver driver) {
        if (driver != null) {
            SerenityWebdriverManager.inThisTestThread().registerDriverCalled(this.nameOf(driver)).forDriver(driver);
            SerenityWebdriverManager.inThisTestThread().setCurrentDriverTo(driver);
        }
    }

    private String nameOf(WebDriver driver) {
        if (driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)driver).getDriverName();
        }
        return driver.toString();
    }

    @Override
    public List<WebDriver> getRegisteredDrivers() {
        return SerenityWebdriverManager.inThisTestThread().getActiveDrivers();
    }

    @Override
    public List<String> getActiveDriverTypes() {
        return SerenityWebdriverManager.inThisTestThread().getActiveDriverTypes();
    }

    @Override
    public String getCurrentDriverType() {
        return SerenityWebdriverManager.inThisTestThread().getCurrentDriverType();
    }

    @Override
    public String getDefaultDriverType() {
        return (String)this.overridenDefaultDriverType.or((Object)this.configuration.getDriverType().name());
    }

    @Override
    public void overrideDefaultDriverType(String driverType) {
        this.overridenDefaultDriverType = Optional.fromNullable((Object)(StringUtils.isEmpty((CharSequence)driverType) ? null : driverType));
    }

    @Override
    public SessionId getSessionId() {
        WebDriver driver = SerenityWebdriverManager.inThisTestThread().getCurrentDriver();
        if (driver instanceof WebDriverFacade && ((WebDriverFacade)driver).isInstantiated()) {
            WebDriver proxiedDriver = ((WebDriverFacade)driver).getDriverInstance();
            return this.sessionIdOf(proxiedDriver);
        }
        return this.sessionIdOf(driver);
    }

    private SessionId sessionIdOf(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            return ((RemoteWebDriver)driver).getSessionId();
        }
        return null;
    }

    @Override
    public WebDriver getWebdriver(String driverName) {
        String name = StringUtils.isEmpty((CharSequence)driverName) ? SerenityWebdriverManager.inThisTestThread().getCurrentDriverName() : driverName;
        WebDriver activeDriver = SerenityWebdriverManager.instantiatedThreadLocalWebDriver(this.configuration, this.webDriverFactory, name);
        return activeDriver;
    }

    @Override
    public WebDriver getCurrentDriver() {
        return SerenityWebdriverManager.inThisTestThread().getCurrentDriver();
    }

    @Override
    public WebDriver getWebdriverByName(String name, String driver) {
        return this.getWebdriver(driver + ":" + name);
    }

    @Override
    public WebDriver getWebdriverByName(String name) {
        return this.getWebdriverByName(name, this.configuration.getDriverType().name());
    }

    private static WebDriver instantiatedThreadLocalWebDriver(Configuration configuration, WebDriverFactory webDriverFactory, String driver) {
        if (!SerenityWebdriverManager.inThisTestThread().driverIsRegisteredFor(driver)) {
            SerenityWebdriverManager.inThisTestThread().registerDriverCalled(driver).forDriver(SerenityWebdriverManager.newDriver(configuration, webDriverFactory, SerenityWebdriverManager.driverTypeOf(driver)));
        }
        return SerenityWebdriverManager.inThisTestThread().useDriver(driver);
    }

    private static String driverTypeOf(String driverName) {
        if (driverName.contains(":")) {
            return driverName.substring(0, driverName.indexOf(":"));
        }
        return driverName;
    }

    public static WebdriverInstances inThisTestThread() {
        if (webdriverInstancesThreadLocal.get() == null) {
            webdriverInstancesThreadLocal.set(new WebdriverInstances());
        }
        return webdriverInstancesThreadLocal.get();
    }

    @Override
    public int getCurrentActiveWebdriverCount() {
        return SerenityWebdriverManager.inThisTestThread().getActiveWebdriverCount();
    }

    @Override
    public int getActiveWebdriverCount() {
        return SerenityWebdriverManager.inThisTestThread().getActiveWebdriverCount();
    }

    @Override
    public boolean hasAnInstantiatedDriver() {
        return SerenityWebdriverManager.inThisTestThread().hasAnInstantiatedDriver();
    }
}

