/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

class CapabilitySet {
    private final EnvironmentVariables environmentVariables;
    private static final CharMatcher CAPABILITY_SEPARATOR = CharMatcher.anyOf((CharSequence)";");
    private static final char CAPABILITY_NAME_VALUE_SEPARATOR = ':';

    CapabilitySet(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables.copy();
    }

    public Map<String, Object> getCapabilities() {
        Map<Object, Object> capabilitiesMap = Maps.newHashMap();
        String specifiedCapabilities = ThucydidesSystemProperty.THUCYDIDES_DRIVER_CAPABILITIES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)specifiedCapabilities)) {
            Iterable capabilityValues = Splitter.on((CharMatcher)CAPABILITY_SEPARATOR).trimResults().split((CharSequence)specifiedCapabilities);
            capabilitiesMap = this.addCapabilityMapValues(capabilityValues);
        }
        return capabilitiesMap;
    }

    private Map<String, Object> addCapabilityMapValues(Iterable<String> capabilityValues) {
        HashMap capabilitiesMap = Maps.newHashMap();
        for (String capability : capabilityValues) {
            CapabilityToken token = new CapabilityToken(capability);
            if (!token.isDefined()) continue;
            capabilitiesMap.put(token.getName(), this.asObject(token.getValue()));
        }
        return capabilitiesMap;
    }

    private Object asObject(String value) {
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            return Boolean.parseBoolean(value);
        }
        if (this.isAList(value)) {
            return this.asList(value);
        }
        return value;
    }

    private List<Object> asList(String value) {
        String listContents = StringUtils.removeEnd((String)StringUtils.removeStart((String)value, (String)"["), (String)"]");
        ArrayList items = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)listContents));
        return Lambda.convert((Object)items, this.toObject());
    }

    private Converter<String, Object> toObject() {
        return new Converter<String, Object>(){

            public Object convert(String from) {
                return CapabilitySet.this.asObject(from);
            }
        };
    }

    private boolean isAList(String value) {
        return value.startsWith("[") && value.endsWith("]");
    }

    private static class CapabilityToken {
        private final String name;
        private final String value;

        private CapabilityToken(String capability) {
            int colonIndex = capability.indexOf(":");
            if (colonIndex >= 0) {
                this.name = capability.substring(0, colonIndex);
                this.value = capability.substring(colonIndex + 1);
            } else {
                this.name = capability;
                this.value = null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isDefined() {
            return StringUtils.isNotEmpty((CharSequence)this.name) && StringUtils.isNotEmpty((CharSequence)this.value);
        }
    }
}

