/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.logging.LoggingLevel;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.failures.FailureAnalysis;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleLoggingListener
implements StepListener {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[91m";
    public static final String ANSI_GREEN = "\u001b[92m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[95m";
    public static final String ANSI_CYAN = "\u001b[96m";
    public static final String SERENITY_BIG_BANNER = "\n\n-------------------------------------------------------------------------------------\n     _______. _______ .______       _______ .__   __.  __  .___________.____    ____ \n    /       ||   ____||   _  \\     |   ____||  \\ |  | |  | |           |\\   \\  /   / \n   |   (----`|  |__   |  |_)  |    |  |__   |   \\|  | |  | `---|  |----` \\   \\/   /  \n    \\   \\    |   __|  |      /     |   __|  |  . `  | |  |     |  |       \\_    _/   \n.----)   |   |  |____ |  |\\  \\----.|  |____ |  |\\   | |  |     |  |         |  |     \n|_______/    |_______|| _| `._____||_______||__| \\__| |__|     |__|         |__|    \n-------------------------------------------------------------------------------------\n";
    public static final String SERENITY_SMALL_BANNER = "\n--------------\n- SERENITY   -\n--------------";
    private static final List<String> BANNER_HEADINGS = ImmutableList.of((Object)"\n--------------\n- SERENITY   -\n--------------", (Object)"\n\n-------------------------------------------------------------------------------------\n     _______. _______ .______       _______ .__   __.  __  .___________.____    ____ \n    /       ||   ____||   _  \\     |   ____||  \\ |  | |  | |           |\\   \\  /   / \n   |   (----`|  |__   |  |_)  |    |  |__   |   \\|  | |  | `---|  |----` \\   \\/   /  \n    \\   \\    |   __|  |      /     |   __|  |  . `  | |  |     |  |       \\_    _/   \n.----)   |   |  |____ |  |\\  \\----.|  |____ |  |\\   | |  |     |  |         |  |     \n|_______/    |_______|| _| `._____||_______||__| \\__| |__|     |__|         |__|    \n-------------------------------------------------------------------------------------\n");
    private static final List<String> TEST_STARTED_HEADINGS = ImmutableList.of((Object)"\n----------------\n- TEST STARTED -\n----------------", (Object)"\n _____ _____ ____ _____   ____ _____  _    ____ _____ _____ ____  \n|_   _| ____/ ___|_   _| / ___|_   _|/ \\  |  _ \\_   _| ____|  _ \\ \n  | | |  _| \\___ \\ | |   \\___ \\ | | / _ \\ | |_) || | |  _| | | | |\n  | | | |___ ___) || |    ___) || |/ ___ \\|  _ < | | | |___| |_| |\n  |_| |_____|____/ |_|   |____/ |_/_/   \\_\\_| \\_\\|_| |_____|____/ \n                                                                  \n");
    private static final List<String> TEST_PASSED_HEADINGS = ImmutableList.of((Object)"\n---------------\n- TEST PASSED -\n---------------", (Object)"\n        __    _____ _____ ____ _____   ____   _    ____  ____  _____ ____  \n  _     \\ \\  |_   _| ____/ ___|_   _| |  _ \\ / \\  / ___|/ ___|| ____|  _ \\ \n (_)_____| |   | | |  _| \\___ \\ | |   | |_) / _ \\ \\___ \\\\___ \\|  _| | | | |\n  _|_____| |   | | | |___ ___) || |   |  __/ ___ \\ ___) |___) | |___| |_| |\n (_)     | |   |_| |_____|____/ |_|   |_| /_/   \\_\\____/|____/|_____|____/ \n        /_/                                                                \n");
    private static final List<String> TEST_FAILED_HEADINGS = ImmutableList.of((Object)"\n----------------\n- TEST FAILED -\n----------------", (Object)"\n           __  _____ _____ ____ _____   _____ _    ___ _     _____ ____  \n  _       / / |_   _| ____/ ___|_   _| |  ___/ \\  |_ _| |   | ____|  _ \\ \n (_)_____| |    | | |  _| \\___ \\ | |   | |_ / _ \\  | || |   |  _| | | | |\n  _|_____| |    | | | |___ ___) || |   |  _/ ___ \\ | || |___| |___| |_| |\n (_)     | |    |_| |_____|____/ |_|   |_|/_/   \\_\\___|_____|_____|____/ \n          \\_\\                                                            \n");
    private static final List<String> TEST_ERROR_HEADINGS = ImmutableList.of((Object)"\n--------------------------\n- TEST FAILED WITH ERROR-\n--------------------------", (Object)"\n         __  _____ _____ ____ _____   _____ ____  ____   ___  ____  \n _      / / |_   _| ____/ ___|_   _| | ____|  _ \\|  _ \\ / _ \\|  _ \\ \n(_)____| |    | | |  _| \\___ \\ | |   |  _| | |_) | |_) | | | | |_) |\n |_____| |    | | | |___ ___) || |   | |___|  _ <|  _ <| |_| |  _ < \n(_)    | |    |_| |_____|____/ |_|   |_____|_| \\_\\_| \\_\\\\___/|_| \\_\\\n        \\_\\                                                         \n");
    private static final List<String> TEST_COMPROMISED_HEADINGS = ImmutableList.of((Object)"\n--------------------------\n- TEST COMPROMISED -\n--------------------------", (Object)"\n         __  _____ _____ ____ _____ \n _      / / |_   _| ____/ ___|_   _|\n(_)____| |    | | |  _| \\___ \\ | |  \n |_____| |    | | | |___ ___) || |  \n(_)    | |    |_| |_____|____/ |_|  \n        \\_\\                         \n  ____ ___  __  __ ____  ____   ___  __  __ ___ ____  _____ ____  \n / ___/ _ \\|  \\/  |  _ \\|  _ \\ / _ \\|  \\/  |_ _/ ___|| ____|  _ \\ \n| |  | | | | |\\/| | |_) | |_) | | | | |\\/| || |\\___ \\|  _| | | | |\n| |__| |_| | |  | |  __/|  _ <| |_| | |  | || | ___) | |___| |_| |\n \\____\\___/|_|  |_|_|   |_| \\_\\\\___/|_|  |_|___|____/|_____|____/\n");
    private static final List<String> TEST_SKIPPED_HEADINGS = ImmutableList.of((Object)"\n----------------\n- TEST SKIPPED -\n----------------", (Object)"\n            __  _____ _____ ____ _____   ____  _  _____ ____  ____  _____ ____  \n  _        / / |_   _| ____/ ___|_   _| / ___|| |/ /_ _|  _ \\|  _ \\| ____|  _ \\ \n (_)_____ / /    | | |  _| \\___ \\ | |   \\___ \\| ' / | || |_) | |_) |  _| | | | |\n  _|_____/ /     | | | |___ ___) || |    ___) | . \\ | ||  __/|  __/| |___| |_| |\n (_)    /_/      |_| |_____|____/ |_|   |____/|_|\\_\\___|_|   |_|   |_____|____/ \n                                                                                \n");
    private static final List<String> TEST_PENDING_HEADINGS = ImmutableList.of((Object)"\n----------------\n- TEST PENDING -\n----------------", (Object)"\n          __  _____ _____ ____ _____   ____  _____ _   _ ____ ___ _   _  ____ \n _       / / |_   _| ____/ ___|_   _| |  _ \\| ____| \\ | |  _ \\_ _| \\ | |/ ___|\n(_)____ / /    | | |  _| \\___ \\ | |   | |_) |  _| |  \\| | | | | ||  \\| | |  _ \n |_____/ /     | | | |___ ___) || |   |  __/| |___| |\\  | |_| | || |\\  | |_| |\n(_)   /_/      |_| |_____|____/ |_|   |_|   |_____|_| \\_|____/___|_| \\_|\\____|\n                                                                                \n");
    private static List<String> FAILURE_HEADINGS = ImmutableList.of((Object)"\n-----------\n- FAILURE -\n-----------", (Object)"\n  _____ _    ___ _     _   _ ____  _____ \n |  ___/ \\  |_ _| |   | | | |  _ \\| ____|\n | |_ / _ \\  | || |   | | | | |_) |  _|  \n |  _/ ___ \\ | || |___| |_| |  _ <| |___ \n |_|/_/   \\_\\___|_____|\\___/|_| \\_\\_____|\n                                         \n");
    private static List<String> ERROR_HEADINGS = ImmutableList.of((Object)"\n-----------\n- FAILED WITH ERROR -\n-----------", (Object)"\n _____ ____  ____   ___  ____  \n| ____|  _ \\|  _ \\ / _ \\|  _ \\ \n|  _| | |_) | |_) | | | | |_) |\n| |___|  _ <|  _ <| |_| |  _ < \n|_____|_| \\_\\_| \\_\\\\___/|_| \\_\\\n\n                                         \n");
    private final Logger logger;
    private final EnvironmentVariables environmentVariables;
    private final int headingStyle;
    private final FailureAnalysis analysis;

    public ConsoleLoggingListener(EnvironmentVariables environmentVariables, Logger logger) {
        this.logger = logger;
        this.environmentVariables = environmentVariables;
        this.analysis = new FailureAnalysis(environmentVariables);
        String headerStyleValue = ThucydidesSystemProperty.THUCYDIDES_CONSOLE_HEADINGS.from(environmentVariables, HeadingStyle.ASCII.toString()).toUpperCase();
        this.headingStyle = HeadingStyle.NORMAL.toString().equals(headerStyleValue) ? 0 : 1;
        this.logBanner();
    }

    @Inject
    public ConsoleLoggingListener(EnvironmentVariables environmentVariables) {
        this(environmentVariables, LoggerFactory.getLogger(Serenity.class));
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private void logBanner() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.bannerHeading());
        }
    }

    private String bannerHeading() {
        return this.cyan(BANNER_HEADINGS.get(this.headingStyle));
    }

    private boolean loggingLevelIsAtLeast(LoggingLevel minimumLoggingLevel) {
        return this.getLoggingLevel().compareTo(minimumLoggingLevel) >= 0;
    }

    private LoggingLevel getLoggingLevel() {
        String logLevel = ThucydidesSystemProperty.THUCYDIDES_LOGGING.from(this.environmentVariables, LoggingLevel.NORMAL.name());
        return LoggingLevel.valueOf(logLevel);
    }

    @Override
    public void testSuiteStarted(Class<?> storyClass) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("Test Suite Started: {}", (Object)NameConverter.humanize(storyClass.getSimpleName()));
        }
    }

    @Override
    public void testSuiteStarted(Story story) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("Test Suite Started: {}", (Object)NameConverter.humanize(story.getName()));
        }
    }

    @Override
    public void testSuiteFinished() {
    }

    @Override
    public void testStarted(String description) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.testStartedHeadings() + "\nTEST STARTED: " + description + this.underline(TEST_STARTED_HEADINGS.get(this.headingStyle)));
        }
    }

    private String testStartedHeadings() {
        return TEST_STARTED_HEADINGS.get(this.headingStyle);
    }

    private String underline(String banner) {
        StringBuilder underline = new StringBuilder();
        int endOfLine = banner.indexOf(10, 1);
        if (endOfLine >= 0) {
            underline.append(StringUtils.repeat((char)'-', (int)endOfLine));
        } else {
            underline.append(StringUtils.repeat((char)'-', (int)banner.length()));
        }
        return "\n" + underline.toString();
    }

    @Override
    public void testFinished(TestOutcome result) {
        if (result.isFailure().booleanValue()) {
            this.logFailure(result);
        }
        if (result.isError().booleanValue()) {
            this.logError(result);
        }
        if (result.isCompromised().booleanValue()) {
            this.logCompromised(result);
        }
        if (result.isPending().booleanValue()) {
            this.logPending(result);
        }
        if (result.isSkipped().booleanValue()) {
            this.logSkipped(result);
        }
        if (result.isSuccess().booleanValue()) {
            this.logSuccess(result);
        }
    }

    @Override
    public void testRetried() {
    }

    private void logFailure(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().error(this.red(this.testFailureHeading() + "\nTEST FAILED: {}"), (Object)(result.getTitle() + this.underline(TEST_FAILED_HEADINGS.get(this.headingStyle))));
            this.logRelatedIssues(result);
            this.logFailureCause(result);
            this.underline(FAILURE_HEADINGS.get(this.headingStyle));
        }
    }

    private void logError(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().error(this.red(this.testFailureHeading() + "\nTEST FAILED WITH ERROR: {}"), (Object)(result.getTitle() + this.underline(TEST_ERROR_HEADINGS.get(this.headingStyle))));
            this.logRelatedIssues(result);
            this.logFailureCause(result);
            this.underline(ERROR_HEADINGS.get(this.headingStyle));
        }
    }

    private void logCompromised(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().error(this.purple(this.testFailureHeading() + "\nTEST COMPROMISED: {}"), (Object)(result.getTitle() + this.underline(TEST_COMPROMISED_HEADINGS.get(this.headingStyle))));
            this.logRelatedIssues(result);
            this.logFailureCause(result);
            this.underline(ERROR_HEADINGS.get(this.headingStyle));
        }
    }

    private String testFailureHeading() {
        return TEST_FAILED_HEADINGS.get(this.headingStyle);
    }

    private void logRelatedIssues(TestOutcome result) {
        Joiner joiner = Joiner.on((String)",");
        this.getLogger().debug("RELATED ISSUES: {}", (Object)joiner.join(result.getIssueKeys()));
    }

    private void logFailureCause(TestOutcome result) {
        if (result.getNestedTestFailureCause() != null) {
            if (result.getFailingStep().isPresent()) {
                String failingStep = ((TestStep)result.getFailingStep().get()).unrendered().getDescription();
                this.getLogger().error(this.red("TEST FAILED AT STEP " + failingStep));
            }
            this.getLogger().error(result.getNestedTestFailureCause().getShortenedMessage());
        }
    }

    private void logPending(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.cyan(this.testPendingHeading() + "\nTEST PENDING: {}"), (Object)(result.getTitle() + this.underline(this.testSkippedHeading())));
        }
    }

    private String testSkippedHeading() {
        return TEST_SKIPPED_HEADINGS.get(this.headingStyle);
    }

    private String testPendingHeading() {
        return TEST_PENDING_HEADINGS.get(this.headingStyle);
    }

    private void logSkipped(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.yellow(this.testSkippedHeading() + "\nTEST SKIPPED: {}"), (Object)(result.getTitle() + this.underline(this.testSkippedHeading())));
        }
    }

    private void logSuccess(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.green(this.testPassedHeading() + "\nTEST PASSED: {}"), (Object)(result.getTitle() + this.underline(this.testPassedHeading())));
        }
    }

    private String testPassedHeading() {
        return TEST_PASSED_HEADINGS.get(this.headingStyle);
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("STARTING STEP {}", (Object)description.getTitle());
        }
    }

    @Override
    public void skippedStepStarted(ExecutedStepDescription description) {
        this.stepStarted(description);
    }

    @Override
    public void stepFinished() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("FINISHING STEP");
        }
    }

    @Override
    public void stepFailed(StepFailure failure) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            String errorMessage = failure.getException() != null ? failure.getException().toString() : failure.getMessage();
            String failureType = this.analysis.resultFor(failure.getException()).name();
            this.getLogger().info(this.red("STEP {}: {}"), (Object)failureType, (Object)errorMessage);
        }
    }

    @Override
    public void lastStepFailed(StepFailure failure) {
    }

    @Override
    public void stepIgnored() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info(this.yellow("IGNORING STEP"));
        }
    }

    @Override
    public void stepPending() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info(this.cyan("PENDING STEP"));
        }
    }

    @Override
    public void stepPending(String message) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info(this.cyan("PENDING STEP ({})"), (Object)message);
        }
    }

    @Override
    public void testFailed(TestOutcome testOutcome, Throwable cause) {
    }

    @Override
    public void testIgnored() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.yellow("TEST IGNORED"));
        }
    }

    @Override
    public void testSkipped() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.yellow("TEST SKIPPED"));
        }
    }

    @Override
    public void testPending() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.cyan("TEST PENDING"));
        }
    }

    @Override
    public void testIsManual() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("TEST MANUAL");
        }
    }

    @Override
    public void notifyScreenChange() {
    }

    @Override
    public void useExamplesFrom(DataTable table) {
    }

    @Override
    public void addNewExamplesFrom(DataTable table) {
    }

    @Override
    public void exampleStarted(Map<String, String> data) {
    }

    @Override
    public void exampleFinished() {
    }

    @Override
    public void assumptionViolated(String message) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().error(this.red("ASSUMPTION VIOLATED: " + message));
        }
    }

    @Override
    public void testRunFinished() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("FINISHING TEST RUN");
        }
    }

    private boolean showColoredOutput() {
        return ThucydidesSystemProperty.THUCYDIDES_CONSOLE_COLORS.booleanFrom(this.environmentVariables, false);
    }

    private String red(String text) {
        return this.showColoredOutput() ? ANSI_RED + text + ANSI_RESET : text;
    }

    private String green(String text) {
        return this.showColoredOutput() ? ANSI_GREEN + text + ANSI_RESET : text;
    }

    private String yellow(String text) {
        return this.showColoredOutput() ? ANSI_YELLOW + text + ANSI_RESET : text;
    }

    private String cyan(String text) {
        return this.showColoredOutput() ? ANSI_CYAN + text + ANSI_RESET : text;
    }

    private String purple(String text) {
        return this.showColoredOutput() ? ANSI_PURPLE + text + ANSI_RESET : text;
    }

    private static enum HeadingStyle {
        NORMAL,
        ASCII;

    }
}

