/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderFilter;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.statistics.service.TagProviderStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathTagProviderService
implements TagProviderService {
    private final Logger logger = LoggerFactory.getLogger(ClasspathTagProviderService.class);
    private List<TagProvider> tagProviders;
    private TagProviderFilter<TagProvider> filter = new TagProviderFilter();

    @Override
    public List<TagProvider> getTagProviders() {
        return this.getTagProviders(null);
    }

    @Override
    public List<TagProvider> getTagProviders(String testSource) {
        if (this.tagProviders == null) {
            ArrayList newTagProviders = Lists.newArrayList();
            Iterable<? extends TagProvider> tagProviderServiceLoader = this.loadTagProvidersFromPath(testSource);
            for (TagProvider tagProvider : tagProviderServiceLoader) {
                newTagProviders.add(tagProvider);
            }
            this.tagProviders = this.filter.removeOverriddenProviders(newTagProviders);
        }
        return this.tagProviders;
    }

    protected Iterable<? extends TagProvider> loadTagProvidersFromPath(String testSource) {
        if (testSource == null) {
            return this.allKnownTagProviders();
        }
        return this.tagProvidersThatCanProcess(testSource);
    }

    private Iterable<? extends TagProvider> tagProvidersThatCanProcess(String testSource) {
        ServiceLoader<TagProviderStrategy> tagProviderStrategies = ServiceLoader.load(TagProviderStrategy.class);
        for (TagProviderStrategy strategy : tagProviderStrategies) {
            if (!strategy.canHandleTestSource(testSource)) continue;
            return strategy.getTagProviders();
        }
        return Lists.newArrayList();
    }

    private Iterable<TagProvider> allKnownTagProviders() {
        ArrayList tagProviders = Lists.newArrayList();
        ServiceLoader<TagProviderStrategy> tagProviderStrategies = ServiceLoader.load(TagProviderStrategy.class);
        for (TagProviderStrategy strategy : tagProviderStrategies) {
            tagProviders.addAll(Lists.newArrayList(strategy.getTagProviders()));
        }
        return tagProviders;
    }
}

