/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.AcceptanceCriteriaRequirmentCounter;
import net.thucydides.core.requirements.reports.ChildRequirementCounter;
import net.thucydides.core.requirements.reports.RequirmentCalculator;
import net.thucydides.core.requirements.reports.SubrequirementsPercentageCount;
import net.thucydides.core.requirements.reports.SubrequirementsProportionCount;

public class SubrequirementsCount {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;

    public SubrequirementsCount(Requirement requirement, TestOutcomes testOutcomes) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
    }

    public SubrequirementsProportionCount getProportion() {
        return new SubrequirementsProportionCount(this);
    }

    public SubrequirementsPercentageCount getPercentage() {
        return new SubrequirementsPercentageCount(this);
    }

    public int getTotal() {
        return this.requirement.hasChildren() ? this.usingChildRequirements().countAllSubrequirements() : this.usingAcceptanceCriteria().countAllSubrequirements();
    }

    public int withResult(String resultValue) {
        TestResult result = TestResult.valueOf(resultValue.toUpperCase());
        return this.requirement.hasChildren() ? this.usingChildRequirements().countSubrequirementsWithResult(result) : this.usingAcceptanceCriteria().countSubrequirementsWithResult(result);
    }

    public int withNoTests() {
        return this.requirement.hasChildren() ? this.usingChildRequirements().countSubrequirementsWithNoTests() : this.usingAcceptanceCriteria().countSubrequirementsWithNoTests();
    }

    private RequirmentCalculator usingChildRequirements() {
        return new ChildRequirementCounter(this.requirement, this.testOutcomes);
    }

    private RequirmentCalculator usingAcceptanceCriteria() {
        return new AcceptanceCriteriaRequirmentCounter(this.testOutcomes);
    }
}

