/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.Release;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.HtmlRequirementsReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;

public class RequirementsReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String REQUIREMENT_TYPE_TEMPLATE_PATH = "freemarker/requirement-type.ftl";
    private static final String RELEASE_TEMPLATE_PATH = "freemarker/release.ftl";
    private static final String RELEASES_TEMPLATE_PATH = "freemarker/releases.ftl";
    private ReportNameProvider reportNameProvider;
    private RequirementsOutcomeFactory requirementsFactory;
    private HtmlRequirementsReporter htmlRequirementsReporter;
    private ReleaseManager releaseManager;
    private final RequirementsService requirementsService;
    private final RequirementsConfiguration requirementsConfiguration;
    List<Requirement> reportTally = Lists.newArrayList();

    public RequirementsReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsOutcomeFactory requirementsFactory, RequirementsService requirementsService, String relativeLink) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.requirementsFactory = requirementsFactory;
        this.requirementsService = requirementsService;
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.htmlRequirementsReporter = new HtmlRequirementsReporter(relativeLink, (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), requirementsService);
        this.htmlRequirementsReporter.setOutputDirectory(outputDirectory);
    }

    @Override
    public void generateReportsFor(TestOutcomes testOutcomes) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        RequirementsOutcomes requirementsOutcomes = this.requirementsFactory.buildRequirementsOutcomesFrom(testOutcomes);
        this.generateRequirementTypeReports(requirementsOutcomes);
        this.generateRequirementsReportsFor(requirementsOutcomes);
        this.generateReleasesReportFor(testOutcomes, requirementsOutcomes);
        LOGGER.trace("Requirements reports generated: {} ms", (Object)stopwatch.stop());
    }

    private void generateRequirementTypeReports(RequirementsOutcomes requirementsOutcomes) throws IOException {
        for (String requirementType : requirementsOutcomes.getTypes()) {
            this.generateRequirementTypeReportFor(requirementType, requirementsOutcomes.requirementsOfType(requirementType));
        }
    }

    private void generateRequirementTypeReportFor(String requirementType, RequirementsOutcomes requirementsOutcomes) throws IOException {
        Map<String, Object> context = this.freemarker.getBuildContext(requirementsOutcomes.getTestOutcomes(), this.reportNameProvider, true);
        context.put("report", ReportProperties.forAggregateResultsReport());
        context.put("requirementType", requirementType);
        context.put("requirements", requirementsOutcomes);
        String reportName = this.reportNameProvider.forRequirementType(requirementType);
        this.generateReportPage(context, REQUIREMENT_TYPE_TEMPLATE_PATH, reportName);
    }

    public void generateRequirementsReportsFor(RequirementsOutcomes requirementsOutcomes) throws IOException {
        this.htmlRequirementsReporter.generateReportFor(requirementsOutcomes);
        this.clearReportTally();
        this.generateRequirementsReportsForChildRequirements(requirementsOutcomes);
    }

    private void clearReportTally() {
        this.reportTally.clear();
    }

    private void generateRequirementsReportsForChildRequirements(RequirementsOutcomes requirementsOutcomes) throws IOException {
        List<RequirementOutcome> requirementOutcomes = requirementsOutcomes.getRequirementOutcomes();
        for (RequirementOutcome outcome : requirementOutcomes) {
            Requirement requirement = outcome.getRequirement();
            if (this.reportTally.contains(requirement)) continue;
            TestOutcomes testOutcomesForThisRequirement = outcome.getTestOutcomes().forRequirement(requirement);
            RequirementsOutcomes requirementOutcomesForThisRequirement = this.requirementsFactory.buildRequirementsOutcomesFrom(requirement, testOutcomesForThisRequirement);
            this.generateNestedRequirementsReportsFor(requirement, requirementOutcomesForThisRequirement);
        }
    }

    private void generateNestedRequirementsReportsFor(Requirement parentRequirement, RequirementsOutcomes requirementsOutcomes) throws IOException {
        String reportName = this.reportNameProvider.forRequirement(parentRequirement);
        String orphanReportName = this.reportNameProvider.forRequirement(parentRequirement.getName());
        if (!this.reportTally.contains(parentRequirement)) {
            this.reportTally.add(parentRequirement);
            this.htmlRequirementsReporter.generateReportFor(requirementsOutcomes, requirementsOutcomes.getTestOutcomes(), reportName);
            this.htmlRequirementsReporter.generateReportFor(requirementsOutcomes, requirementsOutcomes.getTestOutcomes(), orphanReportName);
        }
        this.generateRequirementsReportsForChildRequirements(requirementsOutcomes);
    }

    private void generateReleasesReportFor(TestOutcomes testOutcomes, RequirementsOutcomes requirementsOutcomes) throws IOException {
        Map<String, Object> context = this.freemarker.getBuildContext(requirementsOutcomes.getTestOutcomes(), this.reportNameProvider, true);
        context.put("report", ReportProperties.forAggregateResultsReport());
        List<Release> releases = this.getReleaseManager().getReleasesFrom(testOutcomes);
        if (!releases.isEmpty()) {
            String releaseData = this.getReleaseManager().getJSONReleasesFrom(testOutcomes);
            context.put("releases", releases);
            context.put("releaseData", releaseData);
            context.put("requirements", requirementsOutcomes);
            this.generateReportPage(context, RELEASES_TEMPLATE_PATH, "releases.html");
            this.generateReleaseDetailsReportsFor(testOutcomes, requirementsOutcomes);
        }
    }

    private void generateReleaseDetailsReportsFor(TestOutcomes testOutcomes, RequirementsOutcomes requirementsOutcomes) throws IOException {
        List<Release> allReleases = this.getReleaseManager().getFlattenedReleasesFrom(testOutcomes);
        List<String> requirementsTypes = this.getRequirementTypes();
        String topLevelRequirementType = requirementsTypes.get(0);
        String secondLevelRequirementType = "";
        String secondLevelRequirementTypeTitle = "";
        String topLevelRequirementTypeTitle = Inflector.getInstance().of(topLevelRequirementType).inPluralForm().asATitle().toString();
        if (requirementsTypes.size() > 1) {
            secondLevelRequirementType = requirementsTypes.get(1);
            secondLevelRequirementTypeTitle = Inflector.getInstance().of(secondLevelRequirementType).inPluralForm().asATitle().toString();
        }
        for (Release release : allReleases) {
            RequirementsOutcomes releaseRequirements = requirementsOutcomes.getReleasedRequirementsFor(release);
            Map<String, Object> context = this.freemarker.getBuildContext(testOutcomes, this.reportNameProvider, true);
            context.put("report", ReportProperties.forAggregateResultsReport());
            context.put("release", release);
            context.put("releaseData", this.getReleaseManager().getJSONReleasesFrom(release));
            context.put("releaseRequirementOutcomes", releaseRequirements.getRequirementOutcomes());
            context.put("releaseTestOutcomes", testOutcomes.withTag(release.getReleaseTag()));
            context.put("requirementType", topLevelRequirementTypeTitle);
            if (StringUtils.isNotBlank((CharSequence)secondLevelRequirementTypeTitle)) {
                context.put("secondLevelRequirementType", secondLevelRequirementTypeTitle);
            }
            String reportName = this.reportNameProvider.forRelease(release);
            this.generateReportPage(context, RELEASE_TEMPLATE_PATH, reportName);
        }
    }

    public List<String> getRequirementTypes() {
        List<String> types = this.requirementsService.getRequirementTypes();
        if (types.isEmpty()) {
            return this.requirementsConfiguration.getRequirementTypes();
        }
        return types;
    }

    private ReleaseManager getReleaseManager() {
        if (this.releaseManager == null) {
            this.releaseManager = new ReleaseManager(this.environmentVariables, this.reportNameProvider);
        }
        return this.releaseManager;
    }
}

