/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.beust.jcommander.internal.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.serenitybdd.core.SerenitySystemProperties;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.html.AggregateReportingTask;
import net.thucydides.core.reports.html.AssociatedTagReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.RequirementsReportingTask;
import net.thucydides.core.reports.html.ResultReportingTask;
import net.thucydides.core.reports.html.TagReportingTask;
import net.thucydides.core.reports.html.TagTypeReportingTask;
import net.thucydides.core.requirements.DefaultRequirements;
import net.thucydides.core.requirements.Requirements;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAggregateStoryReporter
extends HtmlReporter
implements UserStoryTestReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);
    public static final int REPORT_GENERATION_THREAD_POOL_SIZE = 16;
    private static final int MAX_BATCHES = 128;
    private String projectName;
    private String relativeLink;
    private final IssueTracking issueTracking;
    private final RequirementsConfiguration requirementsConfiguration;
    private final ReportNameProvider reportNameProvider;
    private final Requirements requirements;
    private final EnvironmentVariables environmentVariables;
    private final FormatConfiguration formatConfiguration;
    private Stopwatch stopwatch = new Stopwatch();

    public HtmlAggregateStoryReporter(String projectName) {
        this(projectName, "");
    }

    public HtmlAggregateStoryReporter(String projectName, Requirements requirements) {
        this(projectName, "", (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), requirements);
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink) {
        this(projectName, relativeLink, (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public HtmlAggregateStoryReporter(String projectName, IssueTracking issueTracking) {
        this(projectName, "", issueTracking, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), new DefaultRequirements());
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink, IssueTracking issueTracking, EnvironmentVariables environmentVariables) {
        this(projectName, relativeLink, issueTracking, environmentVariables, new DefaultRequirements());
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink, IssueTracking issueTracking, EnvironmentVariables environmentVariables, Requirements requirements) {
        this.projectName = projectName;
        this.relativeLink = relativeLink;
        this.issueTracking = issueTracking;
        this.requirementsConfiguration = new RequirementsConfiguration(this.getEnvironmentVariables());
        this.environmentVariables = environmentVariables;
        this.formatConfiguration = new FormatConfiguration(environmentVariables);
        this.reportNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, requirements.getRequirementsService());
        this.requirements = requirements;
    }

    public OutcomeFormat getFormat() {
        return this.formatConfiguration.getPreferredFormat();
    }

    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public TestOutcomes generateReportsForTestResultsFrom(File sourceDirectory) throws IOException {
        this.copyScreenshotsFrom(sourceDirectory);
        TestOutcomes allTestOutcomes = this.loadTestOutcomesFrom(sourceDirectory);
        this.generateReportsForTestResultsIn(allTestOutcomes);
        return allTestOutcomes;
    }

    private void copyScreenshotsFrom(File sourceDirectory) {
        if (this.getOutputDirectory() == null || this.getOutputDirectory().equals(sourceDirectory)) {
            return;
        }
        CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
        Path targetPath = Paths.get(this.getOutputDirectory().toURI());
        Path sourcePath = Paths.get(sourceDirectory.toURI());
        try (DirectoryStream<Path> directoryContents = Files.newDirectoryStream(sourcePath);){
            for (Path sourceFile : directoryContents) {
                Path destinationFile = targetPath.resolve(sourceFile.getFileName());
                if (!Files.notExists(destinationFile, new LinkOption[0])) continue;
                Files.copy(sourceFile, destinationFile, options);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error during copying files to the target directory", (Throwable)e);
        }
    }

    public void generateReportsForTestResultsIn(TestOutcomes testOutcomes) throws IOException {
        this.copyResourcesToOutputDirectory();
        FreemarkerContext context = new FreemarkerContext(this.environmentVariables, this.requirements.getRequirementsService(), this.issueTracking, this.relativeLink);
        List reportingTasks = Lists.newArrayList();
        reportingTasks.add(new AggregateReportingTask(context, this.environmentVariables, this.requirements.getRequirementsService(), this.getOutputDirectory()));
        reportingTasks.add(new TagReportingTask(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider));
        reportingTasks.add(new TagTypeReportingTask(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider));
        reportingTasks.add(new ResultReportingTask(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider));
        reportingTasks.add(new RequirementsReportingTask(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider, this.requirements.getRequirementsOutcomeFactory(), this.requirements.getRequirementsService(), this.relativeLink));
        this.addAssociatedTagReporters(testOutcomes, context, reportingTasks);
        this.generateReportsFor(testOutcomes, reportingTasks);
        this.copyTestResultsToOutputDirectory();
    }

    private void addAssociatedTagReporters(TestOutcomes testOutcomes, FreemarkerContext context, List<ReportingTask> reportingTasks) {
        int maxPossibleBatches = testOutcomes.getTags().size();
        int totalBatches = 128 < maxPossibleBatches ? 128 : maxPossibleBatches;
        for (int batch = 1; batch <= totalBatches; ++batch) {
            reportingTasks.add(new AssociatedTagReportingTask(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider).forBatch(batch, totalBatches));
        }
    }

    private void generateReportsFor(final TestOutcomes testOutcomes, List<ReportingTask> reportingTasks) throws IOException {
        this.stopwatch.start();
        ExecutorService executor = Executors.newFixedThreadPool(16);
        for (final ReportingTask reportingTask : reportingTasks) {
            Runnable worker = new Runnable(){

                @Override
                public void run() {
                    try {
                        reportingTask.generateReportsFor(testOutcomes);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            executor.execute(worker);
        }
        LOGGER.debug("Shutting down Test outcome reports generation");
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        LOGGER.debug("Test outcome reports generated in {} ms", (Object)this.stopwatch.stop());
    }

    private TestOutcomes loadTestOutcomesFrom(File sourceDirectory) throws IOException {
        return TestOutcomeLoader.loadTestOutcomes().inFormat(this.getFormat()).from(sourceDirectory);
    }

    protected SerenitySystemProperties getSystemProperties() {
        return SerenitySystemProperties.getProperties();
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        if (issueTrackerUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.THUCYDIDES_ISSUE_TRACKER_URL, issueTrackerUrl);
        }
    }

    public void setJiraUrl(String jiraUrl) {
        if (jiraUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_URL, jiraUrl);
        }
    }

    public void setJiraProject(String jiraProject) {
        if (jiraProject != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PROJECT, jiraProject);
        }
    }

    public void setJiraUsername(String jiraUsername) {
        if (jiraUsername != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_USERNAME, jiraUsername);
        }
    }

    public void setJiraPassword(String jiraPassword) {
        if (jiraPassword != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PASSWORD, jiraPassword);
        }
    }

    public List<String> getRequirementTypes() {
        List<String> types = this.requirements.getTypes();
        if (types.isEmpty()) {
            LOGGER.warn("No requirement types found in the test outcome requirements: using default requirements");
            return this.requirementsConfiguration.getRequirementTypes();
        }
        return types;
    }
}

