/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.csv.CSVReporter;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.Merger;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseReportingTask
implements ReportingTask {
    final FreemarkerContext freemarker;
    final EnvironmentVariables environmentVariables;
    final File outputDirectory;
    protected static final Logger LOGGER = LoggerFactory.getLogger(ReportingTask.class);

    public BaseReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory) {
        this.freemarker = freemarker;
        this.environmentVariables = environmentVariables;
        this.outputDirectory = outputDirectory;
    }

    @Override
    public abstract void generateReportsFor(TestOutcomes var1) throws IOException;

    protected void generateReportPage(Map<String, Object> context, String template, String outputFile) throws IOException {
        this.writeReportToOutputDirectory(outputFile, this.mergeTemplate(template).usingContext(context));
    }

    protected Merger mergeTemplate(String templateFile) {
        return new Merger(templateFile);
    }

    protected void generateCSVReportFor(TestOutcomes testOutcomes, String reportName) throws IOException {
        CSVReporter csvReporter = new CSVReporter(this.outputDirectory, this.environmentVariables);
        csvReporter.generateReportFor(testOutcomes, reportName);
    }

    protected File writeReportToOutputDirectory(String reportFilename, String htmlContents) throws IOException {
        File report = new File(this.outputDirectory, reportFilename);
        this.writeToFile(htmlContents, report);
        return report;
    }

    private void writeToFile(String htmlContents, File report) throws IOException {
        String[] lines = htmlContents.split("\\r?\\n");
        try (BufferedWriter writer = Files.newBufferedWriter(report.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }
}

