/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import ch.lambdaj.Lambda;
import com.beust.jcommander.internal.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.ExecutorServiceProvider;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.ReportLoadingFailedError;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOutcomeLoader {
    private final EnvironmentVariables environmentVariables;
    private final FormatConfiguration formatConfiguration;
    private final ExecutorService executor;
    private static final Logger logger = LoggerFactory.getLogger(TestOutcomeLoader.class);

    public TestOutcomeLoader() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    @Inject
    public TestOutcomeLoader(EnvironmentVariables environmentVariables) {
        this(environmentVariables, new FormatConfiguration(environmentVariables));
    }

    public TestOutcomeLoader(EnvironmentVariables environmentVariables, FormatConfiguration formatConfiguration) {
        this.environmentVariables = environmentVariables;
        this.formatConfiguration = formatConfiguration;
        this.executor = ((ExecutorServiceProvider)Injectors.getInjector().getInstance(ExecutorServiceProvider.class)).getExecutorService();
    }

    public TestOutcomeLoader forFormat(OutcomeFormat format) {
        return new TestOutcomeLoader(this.environmentVariables, new FormatConfiguration(format));
    }

    public List<TestOutcome> loadFrom(File reportDirectory) throws ReportLoadingFailedError {
        List testOutcomes = Lists.newArrayList();
        AcceptanceTestLoader testOutcomeReporter = this.getOutcomeReporter();
        Path fromTheReportDirectory = reportDirectory.toPath();
        try (DirectoryStream<Path> directoryContents = Files.newDirectoryStream(fromTheReportDirectory, this.thatContainsTestOutcomeFiles());){
            for (Path sourceFile : directoryContents) {
                testOutcomes.addAll(testOutcomeReporter.loadReportFrom(sourceFile).asSet());
            }
        }
        catch (IOException e) {
            throw new ReportLoadingFailedError("Can not load reports for some reason", e);
        }
        return TestOutcomeLoader.inOrderOfTestExecution(testOutcomes);
    }

    private DirectoryStream.Filter<? super Path> thatContainsTestOutcomeFiles() {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String standardFormatFilename = entry.getFileName().toString().toLowerCase(Locale.getDefault());
                return standardFormatFilename.endsWith(TestOutcomeLoader.this.formatConfiguration.getPreferredFormat().getExtension()) && !standardFormatFilename.endsWith(".features.json") && !standardFormatFilename.startsWith("SERENITY-JUNIT-");
            }
        };
    }

    public static TestOutcomeLoaderBuilder loadTestOutcomes() {
        return new TestOutcomeLoaderBuilder();
    }

    public static TestOutcomes testOutcomesIn(File reportsDirectory) throws IOException {
        TestOutcomeLoader loader = new TestOutcomeLoader();
        return TestOutcomes.of(loader.loadFrom(reportsDirectory));
    }

    private static List<TestOutcome> inOrderOfTestExecution(List<TestOutcome> testOutcomes) {
        return Lambda.sort(testOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getStartTime());
    }

    public AcceptanceTestLoader getOutcomeReporter() {
        switch (this.formatConfiguration.getPreferredFormat()) {
            case XML: {
                return new XMLTestOutcomeReporter();
            }
            case JSON: {
                return new JSONTestOutcomeReporter();
            }
        }
        throw new IllegalArgumentException("Unsupported report format: " + (Object)((Object)this.formatConfiguration.getPreferredFormat()));
    }

    public static final class TestOutcomeLoaderBuilder {
        OutcomeFormat format;

        public TestOutcomeLoaderBuilder inFormat(OutcomeFormat format) {
            this.format = format;
            return this;
        }

        public TestOutcomes from(File reportsDirectory) throws IOException {
            TestOutcomeLoader loader = new TestOutcomeLoader().forFormat(this.format);
            return TestOutcomes.of(loader.loadFrom(reportsDirectory));
        }
    }
}

