/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatConfiguration.class);
    public static final String DEFAULT_FORMATS = "json,xml,html";
    private final List<OutcomeFormat> formats;

    @Inject
    public FormatConfiguration(EnvironmentVariables environmentVariables) {
        List formatNames = Splitter.on((String)",").trimResults().splitToList((CharSequence)ThucydidesSystemProperty.OUTPUT_FORMATS.from(environmentVariables, DEFAULT_FORMATS));
        this.formats = Lists.newArrayList();
        for (String format : formatNames) {
            this.formats.addAll(FormatConfiguration.outcomeFormatFrom(format).asSet());
        }
    }

    public FormatConfiguration(OutcomeFormat ... formatValues) {
        this.formats = Arrays.asList(formatValues);
    }

    private static Optional<OutcomeFormat> outcomeFormatFrom(String value) {
        try {
            return Optional.of((Object)((Object)OutcomeFormat.valueOf(value.toUpperCase())));
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Illegal outcome format ignored: " + value);
            return Optional.absent();
        }
    }

    public List<OutcomeFormat> getFormats() {
        if (this.formats.isEmpty()) {
            throw new IllegalArgumentException("No valid output format has been defined.");
        }
        return this.formats;
    }

    public OutcomeFormat getPreferredFormat() {
        return this.getFormats().get(0);
    }
}

