/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.screenshots;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;

public class ScreenshotPreferencesByClass {
    public static final String SERENITY_TAKE_SCREENSHOTS_FOR = "serenity.take.screenshots.for.";
    private final Class<?> declaringClass;
    private final Map<String, TakeScreenshots> classNameToScreenshotPreference;

    public ScreenshotPreferencesByClass(Class<?> declaringClass, EnvironmentVariables environmentVariables) {
        this.declaringClass = declaringClass;
        this.classNameToScreenshotPreference = this.classNameToScreenshotPreferencesDefinedIn(environmentVariables);
    }

    private Map<String, TakeScreenshots> classNameToScreenshotPreferencesDefinedIn(EnvironmentVariables environmentVariables) {
        HashMap screenshotPreference = Maps.newHashMap();
        for (String key : environmentVariables.getKeys()) {
            if (!key.startsWith(SERENITY_TAKE_SCREENSHOTS_FOR)) continue;
            screenshotPreference.put(this.singularClassNameFrom(key).toLowerCase(), this.screenshotPreferenceValueFrom(environmentVariables.getProperty(key)));
            screenshotPreference.put(this.pluralClassNameFrom(key).toLowerCase(), this.screenshotPreferenceValueFrom(environmentVariables.getProperty(key)));
        }
        return screenshotPreference;
    }

    private TakeScreenshots screenshotPreferenceValueFrom(String screenshotPreference) {
        try {
            return TakeScreenshots.valueOf(screenshotPreference.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Incorrectly configured screenshot value '" + screenshotPreference + "' for serenity.take.screenshots - should be one of " + Arrays.toString((Object[])TakeScreenshots.values()));
        }
    }

    private String singularClassNameFrom(String key) {
        String simpleClassName = key.replace(SERENITY_TAKE_SCREENSHOTS_FOR, "");
        return new Inflector().singularize(simpleClassName);
    }

    private String pluralClassNameFrom(String key) {
        String simpleClassName = key.replace(SERENITY_TAKE_SCREENSHOTS_FOR, "");
        return new Inflector().pluralize(simpleClassName);
    }

    public static ScreenshotPreferencesByClassBuilder forClass(Class<?> declaringClass) {
        return new ScreenshotPreferencesByClassBuilder(declaringClass);
    }

    public Optional<TakeScreenshots> getScreenshotPreference() {
        List<Class<?>> candidateClasses = this.getSuperClassesAndInterfacesFrom(this.declaringClass);
        for (Class<?> candidateClass : candidateClasses) {
            String className = candidateClass.getSimpleName().toLowerCase();
            if (!this.classNameToScreenshotPreference.containsKey(className)) continue;
            return Optional.of((Object)((Object)this.classNameToScreenshotPreference.get(className)));
        }
        return Optional.absent();
    }

    private List<Class<?>> getSuperClassesAndInterfacesFrom(Class<?> declaringClass) {
        List superClassesAndInterfaces = Lists.newArrayList();
        superClassesAndInterfaces.add(declaringClass);
        Collection<Class<?>> superClasses = this.superclassesFrom(declaringClass);
        superClassesAndInterfaces.addAll(this.superclassesFrom(declaringClass));
        superClassesAndInterfaces.addAll(this.interfacesFrom(declaringClass));
        superClassesAndInterfaces.addAll(this.allInterfacesFrom(superClasses));
        return superClassesAndInterfaces;
    }

    private Collection<Class<?>> interfacesFrom(Class<?> declaringClass) {
        List interfaces = Lists.newArrayList();
        interfaces.addAll(Lists.newArrayList((Object[])declaringClass.getInterfaces()));
        for (Class<?> anInterface : declaringClass.getInterfaces()) {
            interfaces.addAll(this.superclassesFrom(anInterface));
            interfaces.addAll(this.interfacesFrom(anInterface));
        }
        return interfaces;
    }

    private Collection<Class<?>> allInterfacesFrom(Collection<Class<?>> superclasses) {
        List interfaces = Lists.newArrayList();
        for (Class<?> superclass : superclasses) {
            interfaces.addAll(this.interfacesFrom(superclass));
        }
        return interfaces;
    }

    private Collection<Class<?>> superclassesFrom(Class<?> declaringClass) {
        List superClasses = Lists.newArrayList();
        for (Class<?> superClass = declaringClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            superClasses.add(superClass);
        }
        return superClasses;
    }

    public static class ScreenshotPreferencesByClassBuilder {
        private final Class<?> declaringClass;

        public ScreenshotPreferencesByClassBuilder(Class<?> declaringClass) {
            this.declaringClass = declaringClass;
        }

        public ScreenshotPreferencesByClass withEnvironmentVariables(EnvironmentVariables environmentVariables) {
            return new ScreenshotPreferencesByClass(this.declaringClass, environmentVariables);
        }
    }
}

