/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TestResult {
    COMPROMISED(5),
    ERROR(4),
    FAILURE(3),
    SKIPPED(2),
    IGNORED(2),
    PENDING(2),
    SUCCESS(1),
    UNDEFINED(0);

    private final int priority;
    private static Logger logger;

    private TestResult(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean overrides(TestResult result) {
        return this.priority > result.priority;
    }

    public boolean isMoreSevereThan(TestResult otherResult) {
        return this.ordinal() > otherResult.ordinal();
    }

    public static boolean existsWithName(String expectedResult) {
        try {
            TestResult.valueOf(expectedResult);
        }
        catch (IllegalArgumentException noMatchingEnumValue) {
            logger.warn("No matching test result value found for {}", (Object)expectedResult);
            return false;
        }
        return true;
    }

    static {
        logger = LoggerFactory.getLogger((String)"net.thucydides.core.model.TestResult");
    }
}

