/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.WebdriverCollectionStrategy;
import net.thucydides.core.annotations.ElementIsUsable;
import net.thucydides.core.annotations.locators.WaitForWebElements;
import org.openqa.selenium.WebElement;

public class WaitForWebElementCollection {
    static Map<WebdriverCollectionStrategy, WaitForWebElements> COLLECTION_STRATEGY = new HashMap<WebdriverCollectionStrategy, WaitForWebElements>();

    public static WaitForWebElements accordingTo(WebdriverCollectionStrategy collectionStrategy) {
        return COLLECTION_STRATEGY.get((Object)collectionStrategy);
    }

    static {
        COLLECTION_STRATEGY.put(WebdriverCollectionStrategy.Optimistic, new WaitForWebElements(){

            @Override
            public boolean areElementsReadyIn(List<WebElement> elements) {
                return elements != null;
            }
        });
        COLLECTION_STRATEGY.put(WebdriverCollectionStrategy.Pessimistic, new WaitForWebElements(){

            @Override
            public boolean areElementsReadyIn(List<WebElement> elements) {
                if (elements == null) {
                    return false;
                }
                return elements.isEmpty() || elements.get(0).isDisplayed();
            }
        });
        COLLECTION_STRATEGY.put(WebdriverCollectionStrategy.Paranoid, new WaitForWebElements(){

            @Override
            public boolean areElementsReadyIn(List<WebElement> elements) {
                if (elements == null) {
                    return false;
                }
                for (WebElement element : elements) {
                    if (ElementIsUsable.forElement(element)) continue;
                    return false;
                }
                return true;
            }
        });
    }
}

