/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Paths;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertiesConfiguration
implements Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropertiesConfiguration.class);
    public static final String DEFAULT_WEBDRIVER_DRIVER = "firefox";
    public static final int DEFAULT_ELEMENT_TIMEOUT_SECONDS = 5;
    public static final Integer DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT = 5;
    public static final String OUTPUT_DIRECTORY_PROPERTY = ThucydidesSystemProperty.THUCYDIDES_OUTPUT_DIRECTORY.getPropertyName();
    public static final String PROJECT_BUILD_DIRECTORY = "project.build.directory";
    private static final String PROJECT_REPORTING_OUTPUT_DIRECTORY = "project.reporting.OutputDirectory";
    public static final String REFUSE_UNTRUSTED_CERTIFICATES = ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.getPropertyName();
    private static final String DEFAULT_OUTPUT_DIRECTORY = "target/site/serenity";
    private File outputDirectory;
    private boolean outputDirectoryResolvedAgainstBuildDir = false;
    private String defaultBaseUrl;
    private final EnvironmentVariables environmentVariables;
    private final FilePathParser filePathParser;

    @Inject
    public SystemPropertiesConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.filePathParser = new FilePathParser(environmentVariables);
    }

    @Override
    public Configuration copy() {
        return this.withEnvironmentVariables(this.environmentVariables);
    }

    @Override
    public Configuration withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        SystemPropertiesConfiguration copy = new SystemPropertiesConfiguration(environmentVariables.copy());
        copy.outputDirectory = null;
        copy.defaultBaseUrl = this.defaultBaseUrl;
        return copy;
    }

    @Override
    public EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public SupportedWebDriver getDriverType() {
        String driverType = WebDriverFactory.getDriverFrom(this.environmentVariables, DEFAULT_WEBDRIVER_DRIVER);
        return this.lookupSupportedDriverTypeFor(driverType);
    }

    public File loadOutputDirectoryFromSystemProperties() {
        String systemDirectoryProperty = ThucydidesSystemProperty.THUCYDIDES_OUTPUT_DIRECTORY.from(this.environmentVariables, this.getMavenBuildDirectory());
        String instantiatedPath = this.filePathParser.getInstanciatedPath(systemDirectoryProperty);
        String systemDefinedDirectory = instantiatedPath != null ? instantiatedPath : DEFAULT_OUTPUT_DIRECTORY;
        File newOutputDirectory = new File(systemDefinedDirectory);
        if (!this.outputDirectoryResolvedAgainstBuildDir && !newOutputDirectory.isAbsolute()) {
            newOutputDirectory = this.resolveIfMavenIsUsed(newOutputDirectory);
        }
        newOutputDirectory.mkdirs();
        LOGGER.info("OutputDirectory : " + newOutputDirectory.getAbsolutePath());
        return newOutputDirectory;
    }

    public void reloadOutputDirectory() {
        this.setOutputDirectory(this.loadOutputDirectoryFromSystemProperties());
    }

    private File resolveIfMavenIsUsed(File path) {
        String mavenBuildDirectory = this.getEnvironmentVariables().getProperty(PROJECT_BUILD_DIRECTORY);
        if (StringUtils.isNotEmpty((CharSequence)mavenBuildDirectory)) {
            return Paths.get(mavenBuildDirectory, new String[0]).resolve(path.toPath()).toFile();
        }
        return path;
    }

    private String getMavenBuildDirectory() {
        LOGGER.info("project.build.directory : " + this.getEnvironmentVariables().getProperty(PROJECT_BUILD_DIRECTORY));
        LOGGER.info("project.reporting.OutputDirectory : " + this.getEnvironmentVariables().getProperty(PROJECT_REPORTING_OUTPUT_DIRECTORY));
        String mavenBuildDirectory = this.getEnvironmentVariables().getProperty(PROJECT_BUILD_DIRECTORY);
        String mavenReportsDirectory = this.getEnvironmentVariables().getProperty(PROJECT_REPORTING_OUTPUT_DIRECTORY);
        String defaultMavenRelativeTargetDirectory = null;
        if (StringUtils.isNotEmpty((CharSequence)mavenReportsDirectory)) {
            defaultMavenRelativeTargetDirectory = mavenReportsDirectory.concat(File.separator).concat("serenity");
            this.outputDirectoryResolvedAgainstBuildDir = true;
        } else if (StringUtils.isNotEmpty((CharSequence)mavenBuildDirectory)) {
            defaultMavenRelativeTargetDirectory = mavenBuildDirectory.concat(File.separator).concat(DEFAULT_OUTPUT_DIRECTORY);
            this.outputDirectoryResolvedAgainstBuildDir = true;
        }
        return defaultMavenRelativeTargetDirectory;
    }

    @Override
    public int getStepDelay() {
        int stepDelay = 0;
        String stepDelayValue = ThucydidesSystemProperty.THUCYDIDES_STEP_DELAY.from(this.environmentVariables);
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            stepDelay = Integer.valueOf(stepDelayValue);
        }
        return stepDelay;
    }

    @Override
    public int getElementTimeout() {
        int elementTimeout = 5;
        String stepDelayValue = ThucydidesSystemProperty.THUCYDIDES_TIMEOUT.from(this.environmentVariables);
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            elementTimeout = Integer.valueOf(stepDelayValue);
        }
        return elementTimeout;
    }

    @Override
    public boolean getUseUniqueBrowser() {
        return this.shouldUseAUniqueBrowser();
    }

    @Override
    public boolean shouldUseAUniqueBrowser() {
        return ThucydidesSystemProperty.THUCYDIDES_USE_UNIQUE_BROWSER.booleanFrom(this.getEnvironmentVariables());
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public File getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.loadOutputDirectoryFromSystemProperties();
        }
        return this.outputDirectory;
    }

    @Override
    public double getEstimatedAverageStepCount() {
        return ThucydidesSystemProperty.THUCYDIDES_ESTIMATED_AVERAGE_STEP_COUNT.integerFrom(this.environmentVariables, DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT);
    }

    @Override
    public boolean onlySaveFailingScreenshots() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.THUCYDIDES_ONLY_SAVE_FAILING_SCREENSHOTS.getPropertyName(), false);
    }

    @Override
    public boolean takeVerboseScreenshots() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.THUCYDIDES_VERBOSE_SCREENSHOTS.getPropertyName(), false);
    }

    @Override
    public Optional<TakeScreenshots> getScreenshotLevel() {
        String takeScreenshotsLevel = ThucydidesSystemProperty.THUCYDIDES_TAKE_SCREENSHOTS.from(this.getEnvironmentVariables());
        if (StringUtils.isNotEmpty((CharSequence)takeScreenshotsLevel)) {
            return Optional.of((Object)((Object)TakeScreenshots.valueOf(takeScreenshotsLevel.toUpperCase())));
        }
        return Optional.absent();
    }

    @Override
    public boolean storeHtmlSourceCode() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.THUCYDIDES_STORE_HTML_SOURCE, false);
    }

    @Override
    public void setIfUndefined(String property, String value) {
        if (this.getEnvironmentVariables().getProperty(property) == null) {
            this.getEnvironmentVariables().setProperty(property, value);
        }
    }

    @Override
    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    @Override
    public int getRestartFrequency() {
        return ThucydidesSystemProperty.THUCYDIDES_RESTART_BROWSER_FREQUENCY.integerFrom(this.environmentVariables);
    }

    @Override
    public int getCurrentTestCount() {
        return 0;
    }

    @Override
    public String getBaseUrl() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_BASE_URL.getPropertyName(), this.defaultBaseUrl);
    }

    private SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.getDriverTypeFor(driverType);
        }
        catch (IllegalArgumentException iae) {
            this.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new UnsupportedDriverException(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }
}

