/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import net.thucydides.core.reports.json.gson.CollectionAdapter;
import net.thucydides.core.reports.json.gson.OptionalTypeAdapter;
import net.thucydides.core.requirements.ChildrenFirstOrderedMap;
import net.thucydides.core.requirements.model.Requirement;

public class RequirementPersister {
    private final File outputDirectory;
    private final String rootDirectory;
    Gson gson;

    public RequirementPersister(File outputDirectory, String rootDirectory) {
        this.outputDirectory = outputDirectory;
        this.rootDirectory = rootDirectory;
        this.gson = new GsonBuilder().registerTypeAdapterFactory(OptionalTypeAdapter.FACTORY).registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).create();
    }

    public SortedMap<String, Requirement> read() throws IOException {
        SortedMap storedRequirementsMap;
        ChildrenFirstOrderedMap map = new ChildrenFirstOrderedMap();
        File jsonFile = new File(this.outputDirectory, this.rootDirectory + ".json");
        if (!jsonFile.exists()) {
            return map;
        }
        Type requirementsMapType = new TypeToken<SortedMap<String, Requirement>>(){}.getType();
        try (FileReader reader = new FileReader(jsonFile);){
            storedRequirementsMap = (SortedMap)this.gson.fromJson((Reader)reader, requirementsMapType);
            if (storedRequirementsMap == null) {
                storedRequirementsMap = Maps.newTreeMap();
            }
        }
        map.putAll(storedRequirementsMap);
        for (Map.Entry entry : storedRequirementsMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.contains(".")) continue;
            String parent = key.substring(0, key.lastIndexOf("."));
            Requirement child = (Requirement)entry.getValue();
            this.updateParentChildren(map, parent, child);
        }
        return map;
    }

    private void updateParentChildren(SortedMap<String, Requirement> map, String parent, Requirement entry) {
        Requirement parentRequirement = (Requirement)map.get(parent);
        Requirement updatedParentRequirement = parentRequirement.withChild(entry);
        map.remove(parent);
        map.put(parent, updatedParentRequirement);
    }

    public void write(SortedMap<String, Requirement> map) throws IOException {
        if (!this.outputDirectory.exists()) {
            Files.createDirectory(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        try (FileWriter writer = new FileWriter(new File(this.outputDirectory, this.rootDirectory + ".json"));){
            this.gson.toJson(map, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }
}

