/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.specflow;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.reports.adaptors.specflow.SpecflowTableRow;

public class SpecflowScenario {
    private final String titleLine;
    private List<String> steps = Lists.newArrayList();
    private List<SpecflowTableRow> rows;

    public SpecflowScenario(String titleLine) {
        this.titleLine = titleLine;
    }

    public String getTitleLine() {
        return this.titleLine;
    }

    public void addSteps(List<String> blockSteps) {
        this.steps.addAll((Collection<String>)ImmutableList.copyOf(blockSteps));
    }

    public List<String> getSteps() {
        return ImmutableList.copyOf(this.steps);
    }

    public void convertToTable(String firstRowTitle) {
        if (this.rows == null) {
            this.rows = Lists.newArrayList();
            this.addRow(firstRowTitle, this.steps);
            this.steps.clear();
        }
    }

    public boolean usesDataTable() {
        return this.rows != null;
    }

    public void addRow(String rowTitle, List<String> rowSteps) {
        this.rows.add(new SpecflowTableRow(rowTitle, (List<String>)ImmutableList.copyOf(rowSteps)));
    }

    public List<SpecflowTableRow> getRows() {
        return ImmutableList.copyOf(this.rows);
    }
}

