/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.images;

import com.jayway.awaitility.Awaitility;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import net.thucydides.core.images.ResizedImage;
import net.thucydides.core.screenshots.ScreenshotException;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizableImage {
    private final File screenshotFile;
    private final int MAX_SUPPORTED_HEIGHT = 4000;
    private Dimension dimension;
    private final Logger logger = LoggerFactory.getLogger(ResizableImage.class);

    protected Logger getLogger() {
        return this.logger;
    }

    public ResizableImage(File screenshotFile) throws IOException {
        this.screenshotFile = screenshotFile;
    }

    public static ResizableImage loadFrom(File screenshotFile) throws IOException {
        return new ResizableImage(screenshotFile);
    }

    public int getWidth() {
        return this.getImageDimension().width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getImageDimension() {
        block25: {
            if (this.dimension != null) {
                return this.dimension;
            }
            String suffix = this.getFileSuffix(this.screenshotFile.getPath());
            Iterator<ImageReader> imageReaders = ImageIO.getImageReadersBySuffix(suffix);
            if (imageReaders.hasNext()) {
                ImageReader reader = imageReaders.next();
                try (FileImageInputStream stream = new FileImageInputStream(this.screenshotFile);){
                    reader.setInput(stream);
                    int width = reader.getWidth(reader.getMinIndex());
                    int height = reader.getHeight(reader.getMinIndex());
                    this.dimension = new Dimension(width, height);
                    break block25;
                }
                catch (IOException e) {
                    this.logger.warn("Could not find the dimensions of the screenshot for " + this.screenshotFile);
                    Dimension dimension = new Dimension(0, 0);
                    return dimension;
                }
                finally {
                    try {
                        reader.dispose();
                    }
                    catch (Throwable e) {
                        this.logger.error("During reader disposing", e);
                    }
                }
            }
            throw new ScreenshotException("Could not find the dimensions of the screenshot for " + this.screenshotFile);
        }
        return this.dimension;
    }

    private String getFileSuffix(String path) {
        String result = null;
        if (path != null) {
            result = "";
            if (path.lastIndexOf(46) != -1 && (result = path.substring(path.lastIndexOf(46))).startsWith(".")) {
                result = result.substring(1);
            }
        }
        return result;
    }

    public int getHeight() {
        return this.getImageDimension().height;
    }

    public ResizableImage rescaleCanvas(int height) throws IOException {
        if (this.skipRescale(height)) {
            return this;
        }
        int targetHeight = Math.min(height, 4000);
        try {
            this.waitForCreationOfFile();
            return this.resizeImage(this.getWidth(), targetHeight, ImageIO.read(this.screenshotFile));
        }
        catch (Throwable e) {
            this.getLogger().warn("Could not resize screenshot, so leaving original version: " + this.screenshotFile, e);
            return this;
        }
    }

    private void waitForCreationOfFile() {
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(this.screenshotIsProcessed());
    }

    private Callable<Boolean> screenshotIsProcessed() {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ResizableImage.this.screenshotFile.exists() && ResizableImage.this.screenshotFile.length() > 0L;
            }
        };
    }

    protected ResizableImage resizeImage(int width, int targetHeight, BufferedImage image) throws IOException {
        BufferedImage resizedImage = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.SPEED, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)width, (int)targetHeight, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        return new ResizedImage(resizedImage, this.screenshotFile);
    }

    private boolean skipRescale(int height) {
        return this.getHeight() > 4000 || this.getHeight() >= height;
    }

    public void saveTo(File savedFile) throws IOException {
        try {
            Files.copy(this.screenshotFile.toPath(), savedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }
}

