/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.requirements.model.Requirement;

public class RequirementsMerger {
    public List<Requirement> merge(Iterable<Requirement> baseRequirements, Iterable<Requirement> newRequirements) {
        ArrayList mergedRequirements = Lists.newArrayList(baseRequirements);
        for (Requirement newRequirement : newRequirements) {
            this.mergeNewRequirement(newRequirement, mergedRequirements);
        }
        return ImmutableList.copyOf((Collection)mergedRequirements);
    }

    private void mergeNewRequirement(Requirement newRequirement, List<Requirement> existingRequirements) {
        if (!existingRequirements.contains(newRequirement)) {
            existingRequirements.add(newRequirement);
        } else {
            Requirement existing = existingRequirements.remove(existingRequirements.indexOf(newRequirement));
            existingRequirements.add(existing.merge(newRequirement));
        }
    }
}

