/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepInterceptor;
import net.thucydides.core.steps.construction.StepLibraryConstructionStrategy;
import net.thucydides.core.steps.construction.StepLibraryType;
import net.thucydides.core.steps.di.DependencyInjectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepFactory {
    private final Pages pages;
    private final Map<Class<?>, Object> index = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(StepFactory.class);
    private final DependencyInjectorService dependencyInjectorService;
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES = new Class[]{Pages.class};

    public StepFactory(Pages pages) {
        this.pages = pages;
        this.dependencyInjectorService = (DependencyInjectorService)Injectors.getInjector().getInstance(DependencyInjectorService.class);
    }

    public StepFactory() {
        this(null);
    }

    public <T> T getStepLibraryFor(Class<T> scenarioStepsClass) {
        if (this.isStepLibraryInstantiatedFor(scenarioStepsClass)) {
            return this.getManagedStepLibraryFor(scenarioStepsClass);
        }
        return this.getNewStepLibraryFor(scenarioStepsClass);
    }

    public <T> T getNewStepLibraryFor(Class<T> scenarioStepsClass) {
        return this.instantiateNewStepLibraryFor(scenarioStepsClass);
    }

    public <T> T getUniqueStepLibraryFor(Class<T> scenarioStepsClass) {
        return this.instantiateUniqueStepLibraryFor(scenarioStepsClass, new Object[0]);
    }

    public <T> T getUniqueStepLibraryFor(Class<T> scenarioStepsClass, Object ... parameters) {
        return this.instantiateUniqueStepLibraryFor(scenarioStepsClass, parameters);
    }

    public void reset() {
        this.index.clear();
    }

    private boolean isStepLibraryInstantiatedFor(Class<?> scenarioStepsClass) {
        return this.index.containsKey(scenarioStepsClass);
    }

    private <T> T getManagedStepLibraryFor(Class<T> scenarioStepsClass) {
        return (T)this.index.get(scenarioStepsClass);
    }

    public <T> T instantiateNewStepLibraryFor(Class<T> scenarioStepsClass) {
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass);
        return this.instantiateNewStepLibraryFor(scenarioStepsClass, stepInterceptor);
    }

    public <T> T instantiateNewStepLibraryFor(Class<T> scenarioStepsClass, MethodInterceptor interceptor) {
        T steps = this.createProxyStepLibrary(scenarioStepsClass, interceptor, new Object[0]);
        this.indexStepLibrary(scenarioStepsClass, steps);
        this.instantiateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        this.injectOtherDependenciesInto(steps);
        return steps;
    }

    private <T> void injectOtherDependenciesInto(T steps) {
        List<DependencyInjector> dependencyInjectors = this.dependencyInjectorService.findDependencyInjectors();
        dependencyInjectors.addAll((Collection<DependencyInjector>)this.getDefaultDependencyInjectors());
        for (DependencyInjector dependencyInjector : dependencyInjectors) {
            dependencyInjector.injectDependenciesInto(steps);
        }
    }

    private ImmutableList<? extends DependencyInjector> getDefaultDependencyInjectors() {
        return this.pages != null ? ImmutableList.of((Object)new PageObjectDependencyInjector(this.pages), (Object)new EnvironmentDependencyInjector()) : ImmutableList.of((Object)new EnvironmentDependencyInjector());
    }

    private <T> T instantiateUniqueStepLibraryFor(Class<T> scenarioStepsClass, Object ... parameters) {
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass);
        T steps = this.createProxyStepLibrary(scenarioStepsClass, stepInterceptor, parameters);
        this.instantiateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        this.injectOtherDependenciesInto(steps);
        return steps;
    }

    private <T> T createProxyStepLibrary(Class<T> scenarioStepsClass, MethodInterceptor interceptor, Object ... parameters) {
        Enhancer e = new Enhancer();
        e.setSuperclass(scenarioStepsClass);
        e.setCallback((Callback)interceptor);
        switch (StepLibraryConstructionStrategy.forClass(scenarioStepsClass).getStrategy()) {
            case STEP_LIBRARY_WITH_WEBDRIVER: {
                return this.webEnabledStepLibrary(scenarioStepsClass, e);
            }
            case STEP_LIBRARY_WITH_PAGES: {
                return this.stepLibraryWithPages(scenarioStepsClass, e);
            }
            case CONSTRUCTOR_WITH_PARAMETERS: {
                return this.immutableStepLibrary(scenarioStepsClass, e, parameters);
            }
        }
        return (T)e.create();
    }

    private <T> T immutableStepLibrary(Class<T> scenarioStepsClass, Enhancer e, Object[] parameters) {
        return (T)e.create((Class[])this.argumentTypesFrom(scenarioStepsClass, parameters), parameters);
    }

    private Class<?>[] argumentTypesFrom(Class<?> scenarioStepsClass, Object[] parameters) {
        for (Constructor<?> candidateConstructor : scenarioStepsClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = candidateConstructor.getParameterTypes();
            if (!this.parametersMatchFor(parameters, parameterTypes)) continue;
            return parameterTypes;
        }
        throw new IllegalArgumentException("Could not find a matching constructor for class " + scenarioStepsClass + "with parameters " + parameters);
    }

    private boolean parametersMatchFor(Object[] parameters, Class<?>[] parameterTypes) {
        int parameterNumber = 0;
        for (Class<?> parameterType : parameterTypes) {
            if (parameterType.isAssignableFrom(parameters[parameterNumber++].getClass())) continue;
            return false;
        }
        return true;
    }

    private <T> T webEnabledStepLibrary(Class<T> scenarioStepsClass, Enhancer e) {
        if (StepLibraryType.ofClass(scenarioStepsClass).hasAPagesConstructor()) {
            Object[] arguments = new Object[]{this.pages};
            return (T)e.create((Class[])CONSTRUCTOR_ARG_TYPES, arguments);
        }
        Object newStepLibrary = e.create();
        return (T)this.injectPagesInto(scenarioStepsClass, newStepLibrary);
    }

    private <T> T stepLibraryWithPages(Class<T> scenarioStepsClass, Enhancer e) {
        Object newStepLibrary = e.create();
        return (T)this.injectPagesInto(scenarioStepsClass, newStepLibrary);
    }

    private <T> T injectPagesInto(Class<T> stepLibraryClass, T newStepLibrary) {
        return new PageInjector(this.pages).injectPagesInto(stepLibraryClass, newStepLibrary);
    }

    private <T> void indexStepLibrary(Class<T> scenarioStepsClass, T steps) {
        this.index.put(scenarioStepsClass, steps);
    }

    private <T> void instantiateAnyNestedStepLibrariesIn(T steps, Class<T> scenarioStepsClass) {
        StepAnnotations.injectNestedScenarioStepsInto(steps, this, scenarioStepsClass);
    }

    class PageInjector {
        private final Pages pages;

        public PageInjector(Pages pages) {
            this.pages = pages;
        }

        public <T> T injectPagesInto(Class<T> stepLibraryClass, T newStepLibrary) {
            if (ScenarioSteps.class.isAssignableFrom(stepLibraryClass)) {
                ((ScenarioSteps)newStepLibrary).setPages(this.pages);
            } else if (StepLibraryType.ofClass(stepLibraryClass).hasAPagesField()) {
                ImmutableSet fields = ImmutableSet.copyOf(Fields.of(stepLibraryClass).allFields());
                Field pagesField = (Field)Iterables.find((Iterable)fields, StepLibraryType.ofTypePages());
                pagesField.setAccessible(true);
                try {
                    pagesField.set(newStepLibrary, this.pages);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Could not instantiate pages field for step library {}", newStepLibrary);
                }
            }
            return newStepLibrary;
        }
    }
}

