/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.thucydides.core.annotations.locators.AbstractListItemHandler;
import net.thucydides.core.annotations.locators.ElementContructorForm;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class WebElementFacadeListItemHandler
extends AbstractListItemHandler<WebElementFacade> {
    private static final String NO_SUITABLE_CONSTRUCTOR_FOUND_FMT2 = "No suitable constructor found.  Expected one of the following:  %s(WebDriver, WebElement, long) or %s(WebDriver, ElementLocator, WebElement, long)";

    public WebElementFacadeListItemHandler(Class<?> interfaceType, ElementLocator locator, WebElement element, PageObject page, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        super(WebElementFacade.class, interfaceType, locator, element, page, implicitTimeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    @Override
    protected Object newElementInstance() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        WebDriver driver = this.page.getDriver();
        if (this.implementerClass == WebElementFacadeImpl.class) {
            return WebElementFacadeImpl.wrapWebElement(driver, this.element, this.implicitTimeoutInMilliseconds, this.waitForTimeoutInMilliseconds, this.locator.toString());
        }
        Object instance = null;
        if (ElementContructorForm.applicableConstructor(this.implementerClass).isPresent()) {
            Constructor constructor = (Constructor)ElementContructorForm.applicableConstructorFrom(this.implementerClass).get();
            switch ((ElementContructorForm)((Object)ElementContructorForm.applicableConstructor(this.implementerClass).get())) {
                case WEBDRIVER_LOCATOR_SINGLE_TIMEOUT: {
                    instance = constructor.newInstance(this.page.getDriver(), this.locator, this.implicitTimeoutInMilliseconds);
                    break;
                }
                case WEBDRIVER_LOCATOR_TWO_TIMEOUTS: {
                    instance = constructor.newInstance(this.page.getDriver(), this.locator, this.implicitTimeoutInMilliseconds, this.waitForTimeoutInMilliseconds);
                    break;
                }
                case WEBDRIVER_ELEMENT_SINGLE_TIMEOUT: {
                    instance = constructor.newInstance(this.page.getDriver(), null, this.element, this.implicitTimeoutInMilliseconds);
                    break;
                }
                case WEBDRIVER_ELEMENT_TWO_TIMEOUTS: {
                    instance = constructor.newInstance(this.page.getDriver(), null, this.element, this.implicitTimeoutInMilliseconds, this.waitForTimeoutInMilliseconds);
                }
            }
        }
        if (instance == null) {
            String className = this.implementerClass.getSimpleName();
            throw new RuntimeException(String.format(NO_SUITABLE_CONSTRUCTOR_FOUND_FMT2, className, className));
        }
        return instance;
    }
}

