/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import com.google.common.base.Optional;
import java.util.List;
import net.thucydides.core.annotations.ClearCookiesPolicy;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.webdriver.WebdriverManager;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

public final class TestCaseAnnotations {
    private final Object testCase;

    public TestCaseAnnotations(Object testCase) {
        this.testCase = testCase;
    }

    public static TestCaseAnnotations forTestCase(Object testCase) {
        return new TestCaseAnnotations(testCase);
    }

    public void injectDriver(WebDriver driver) {
        Optional<ManagedWebDriverAnnotatedField> webDriverField = ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(this.testCase.getClass());
        if (webDriverField.isPresent()) {
            ((ManagedWebDriverAnnotatedField)webDriverField.get()).setValue(this.testCase, driver);
        }
    }

    public void injectDrivers(WebdriverManager webdriverManager) {
        List<ManagedWebDriverAnnotatedField> webDriverFields = ManagedWebDriverAnnotatedField.findAnnotatedFields(this.testCase.getClass());
        int driverCount = 1;
        String suffix = "";
        for (ManagedWebDriverAnnotatedField webDriverField : webDriverFields) {
            String driverRootName = StringUtils.isEmpty((CharSequence)webDriverField.getDriver()) ? webdriverManager.getCurrentDriverName() : webDriverField.getDriver();
            String driverName = driverRootName + suffix;
            webDriverField.setValue(this.testCase, webdriverManager.getWebdriver(driverName));
            suffix = this.nextSuffix(driverCount++);
        }
    }

    private String nextSuffix(int driverCount) {
        return ":" + driverCount + 1;
    }

    public static boolean supportsWebTests(Class clazz) {
        return ManagedWebDriverAnnotatedField.hasManagedWebdriverField(clazz);
    }

    public boolean isUniqueSession() {
        return TestCaseAnnotations.isUniqueSession(this.testCase.getClass());
    }

    public static boolean isUniqueSession(Class<?> testClass) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testClass);
        return webDriverField.isUniqueSession();
    }

    public static boolean isWebTest(Class<?> testClass) {
        return ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(testClass).isPresent();
    }

    public static boolean shouldClearCookiesBeforeEachTestIn(Class<?> testClass) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testClass);
        return webDriverField.getClearCookiesPolicy() == ClearCookiesPolicy.BeforeEachTest;
    }
}

