/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import net.serenitybdd.core.IgnoredStepException;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.SessionMap;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.core.sessions.TestSessionVariables;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.di.DependencyInjectorService;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public class Serenity {
    private static final ThreadLocal<WebDriverFactory> factoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<WebdriverManager> webdriverManagerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Pages> pagesThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepFactory> stepFactoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepListener> stepListenerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<TestSessionVariables> testSessionThreadLocal = new ThreadLocal();
    private static final ThreadLocal<FirefoxProfile> firefoxProfileThreadLocal = new ThreadLocal();
    private static final boolean AND_CLOSE_ALL_DRIVERS = true;
    private static boolean throwExceptionsImmediately = false;

    public static void initialize(Object testCase) {
        Serenity.setupWebDriverFactory();
        Serenity.setupWebdriverManager();
        Serenity.initPagesObjectUsing(Serenity.getDriver());
        Serenity.initStepListener();
        Serenity.initStepFactoryUsing(Serenity.getPages());
        Serenity.injectDriverInto(testCase);
        Serenity.injectAnnotatedPagesObjectInto(testCase);
        Serenity.injectScenarioStepsInto(testCase);
        ThucydidesWebDriverSupport.initializeFieldsIn(testCase);
        Serenity.injectDependenciesInto(testCase);
    }

    private static void injectDependenciesInto(Object testCase) {
        for (DependencyInjector dependencyInjector : Serenity.getDependencyInjectors()) {
            dependencyInjector.injectDependenciesInto(testCase);
        }
    }

    private static void resetDependencyInjectors() {
        for (DependencyInjector dependencyInjector : Serenity.getDependencyInjectors()) {
            dependencyInjector.reset();
        }
    }

    private static List<DependencyInjector> getDependencyInjectors() {
        List<DependencyInjector> dependencyInjectors = Serenity.getDependencyInjectorService().findDependencyInjectors();
        dependencyInjectors.addAll(Serenity.getDefaultDependencyInjectors());
        return dependencyInjectors;
    }

    private static DependencyInjectorService getDependencyInjectorService() {
        return (DependencyInjectorService)Injectors.getInjector().getInstance(DependencyInjectorService.class);
    }

    private static List<DependencyInjector> getDefaultDependencyInjectors() {
        return ImmutableList.of((Object)new PageObjectDependencyInjector(Serenity.getPages()), (Object)new EnvironmentDependencyInjector());
    }

    public static SerenityConfigurer initializeWithNoStepListener(Object testCase) {
        Serenity.setupWebDriverFactory();
        Serenity.setupWebdriverManager();
        Serenity.initPagesObjectUsing(Serenity.getDriver());
        Serenity.initStepFactoryUsing(Serenity.getPages());
        Serenity.injectDriverInto(testCase);
        Serenity.injectAnnotatedPagesObjectInto(testCase);
        Serenity.injectScenarioStepsInto(testCase);
        ThucydidesWebDriverSupport.initializeFieldsIn(testCase);
        Serenity.injectDependenciesInto(testCase);
        return new SerenityConfigurer();
    }

    private static void initStepListener() {
        Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        File outputDirectory = configuration.getOutputDirectory();
        BaseStepListener listener = new BaseStepListener(outputDirectory, Serenity.getPages());
        stepListenerThreadLocal.set(listener);
        StepEventBus.getEventBus().registerListener(Serenity.getStepListener());
    }

    private static void setupWebDriverFactory() {
        factoryThreadLocal.set((WebDriverFactory)Injectors.getInjector().getInstance(WebDriverFactory.class));
    }

    private static void initPagesObjectUsing(WebDriver driver) {
        pagesThreadLocal.set(new Pages(driver));
    }

    private static void initStepFactoryUsing(Pages pagesObject) {
        StepFactory stepFactory = new StepFactory(pagesObject);
        stepFactoryThreadLocal.set(new StepFactory(pagesObject));
    }

    protected static void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDrivers(Serenity.getWebdriverManager());
    }

    public static void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto(testCase, Serenity.getStepFactory());
    }

    protected static void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectOptionalAnnotatedPagesObjectInto(testCase, Serenity.getPages());
    }

    public static void done() {
        Serenity.done(true);
    }

    public static void done(boolean closeAllDrivers) {
        if (closeAllDrivers && Serenity.getWebdriverManager() != null) {
            Serenity.getWebdriverManager().closeAllCurrentDrivers();
        }
        Serenity.resetDependencyInjectors();
    }

    public static String getCurrentSessionID() {
        if (Serenity.getWebdriverManager() != null && Serenity.getWebdriverManager().getSessionId() != null) {
            return Serenity.getWebdriverManager().getSessionId().toString();
        }
        return null;
    }

    protected static WebDriver getDriver() {
        return Serenity.getWebdriverManager().getWebdriver();
    }

    protected static Pages getPages() {
        return pagesThreadLocal.get();
    }

    protected static void stopUsingMockDriver() {
        Serenity.setupWebdriverManager();
    }

    public static WebdriverManager getWebdriverManager() {
        return webdriverManagerThreadLocal.get();
    }

    public static StepFactory getStepFactory() {
        return stepFactoryThreadLocal.get();
    }

    private static void setupWebdriverManager() {
        Serenity.setupWebdriverManager((WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class));
    }

    private static void setupWebdriverManager(WebdriverManager webdriverManager) {
        webdriverManagerThreadLocal.set(webdriverManager);
    }

    public static StepListener getStepListener() {
        return stepListenerThreadLocal.get();
    }

    public static void initializeTestSession() {
        Serenity.getCurrentSession().clear();
    }

    public static SessionMap<Object, Object> getCurrentSession() {
        if (testSessionThreadLocal.get() == null) {
            testSessionThreadLocal.set(new TestSessionVariables());
        }
        return testSessionThreadLocal.get();
    }

    public static void pendingStep(String reason) {
        throw new PendingStepException(reason);
    }

    public static void ignoredStep(String reason) {
        throw new IgnoredStepException(reason);
    }

    public static void takeScreenshot() {
        StepEventBus.getEventBus().takeScreenshot();
    }

    public static String getDefaultProjectKey() {
        String workingDirPath = System.getProperty("user.dir");
        return new File(workingDirPath).getName();
    }

    public static void useFirefoxProfile(FirefoxProfile profile) {
        firefoxProfileThreadLocal.set(profile);
    }

    public static FirefoxProfile getFirefoxProfile() {
        return firefoxProfileThreadLocal.get();
    }

    public static boolean hasASessionVariableCalled(Object key) {
        return Serenity.getCurrentSession().containsKey(key);
    }

    public static <T> T sessionVariableCalled(Object key) {
        return (T)Serenity.getCurrentSession().get(key);
    }

    public static SessionVariableSetter setSessionVariable(Object key) {
        return new SessionVariableSetter(key);
    }

    public static Pages getPagesFactory() {
        return null;
    }

    public static void throwExceptionsImmediately() {
        throwExceptionsImmediately = true;
    }

    public static boolean shouldThrowErrorsImmediately() {
        return throwExceptionsImmediately;
    }

    public static class SerenityConfigurer {
        public SerenityConfigurer throwExceptionsImmediately() {
            Serenity.throwExceptionsImmediately();
            return this;
        }
    }

    public static class SessionVariableSetter {
        final Object key;

        public SessionVariableSetter(Object key) {
            this.key = key;
        }

        public <T> void to(T value) {
            if (value != null) {
                Serenity.getCurrentSession().put(this.key, value);
            } else {
                Serenity.getCurrentSession().remove(this.key);
            }
        }
    }
}

