/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverManager;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;

public class ThucydidesWebDriverSupport {
    private static final ThreadLocal<WebdriverManager> webdriverManagerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Pages> pagesThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepFactory> stepFactoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<String> currentRequestedDriver = new ThreadLocal();

    public static void initialize(String requestedDriver) {
        ThucydidesWebDriverSupport.setRequestedDriverIfPresent(requestedDriver);
        ThucydidesWebDriverSupport.setupWebdriverManager();
        ThucydidesWebDriverSupport.initPagesObjectUsing(ThucydidesWebDriverSupport.getDriver());
        ThucydidesWebDriverSupport.initStepFactoryUsing(ThucydidesWebDriverSupport.getPages());
    }

    public static void initialize() {
        ThucydidesWebDriverSupport.initialize(null);
    }

    private static void setRequestedDriverIfPresent(String requestedDriver) {
        if (StringUtils.isNotEmpty((CharSequence)requestedDriver)) {
            currentRequestedDriver.set(requestedDriver);
        } else {
            currentRequestedDriver.remove();
        }
    }

    private static boolean webdriversInitialized() {
        return webdriverManagerThreadLocal.get() != null;
    }

    private static void lazyInitalize() {
        if (!ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.initialize();
        }
    }

    public static void initializeFieldsIn(Object testCase) {
        ThucydidesWebDriverSupport.injectDriverInto(testCase);
        ThucydidesWebDriverSupport.injectAnnotatedPagesObjectInto(testCase);
    }

    public static StepFactory getStepFactory() {
        ThucydidesWebDriverSupport.lazyInitalize();
        return stepFactoryThreadLocal.get();
    }

    public static void useDriver(WebDriver driver) {
        ThucydidesWebDriverSupport.getWebdriverManager().registerDriver(driver);
    }

    public static WebDriver getDriver() {
        if (currentRequestedDriver.get() != null) {
            return ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver(currentRequestedDriver.get());
        }
        return ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver();
    }

    public static void closeCurrentDrivers() {
        if (ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.getWebdriverManager().closeAllCurrentDrivers();
        }
    }

    public static void closeAllDrivers() {
        if (ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.getWebdriverManager().closeAllDrivers();
        }
    }

    private static void setupWebdriverManager() {
        ThucydidesWebDriverSupport.setupWebdriverManager((WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class));
    }

    private static void setupWebdriverManager(WebdriverManager webdriverManager) {
        webdriverManagerThreadLocal.set(webdriverManager);
    }

    private static void initStepFactoryUsing(Pages pagesObject) {
        stepFactoryThreadLocal.set(new StepFactory(pagesObject));
    }

    public static WebdriverManager getWebdriverManager() {
        ThucydidesWebDriverSupport.lazyInitalize();
        return webdriverManagerThreadLocal.get();
    }

    private static void initPagesObjectUsing(WebDriver driver) {
        pagesThreadLocal.set(new Pages(driver));
    }

    public static Pages getPages() {
        ThucydidesWebDriverSupport.lazyInitalize();
        return pagesThreadLocal.get();
    }

    protected static void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDrivers(ThucydidesWebDriverSupport.getWebdriverManager());
    }

    protected static void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectOptionalAnnotatedPagesObjectInto(testCase, ThucydidesWebDriverSupport.getPages());
    }

    public static <T extends WebDriver> T getProxiedDriver() {
        return (T)((WebDriverFacade)ThucydidesWebDriverSupport.getDriver()).getProxiedDriver();
    }

    public static Class<? extends WebDriver> getDriverClass() {
        return ((WebDriverFacade)ThucydidesWebDriverSupport.getDriver()).getDriverClass();
    }

    public static SessionId getSessionId() {
        return ThucydidesWebDriverSupport.getWebdriverManager().getSessionId();
    }

    public static String getCurrentDriverName() {
        return ThucydidesWebDriverSupport.getWebdriverManager().getCurrentDriverName();
    }

    public static boolean isDriverInstantiated() {
        return ThucydidesWebDriverSupport.getWebdriverManager().isDriverInstantiated();
    }
}

