/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import java.lang.reflect.Method;
import net.thucydides.core.annotations.BlurScreenshots;
import net.thucydides.core.reflection.StackTraceAnalyser;
import net.thucydides.core.screenshots.BlurLevel;

public class ScreenshotBlurCheck {
    public Optional<BlurLevel> blurLevel() {
        return this.fromAnnotation();
    }

    private Optional<BlurLevel> fromAnnotation() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new Throwable().getStackTrace()) {
            Method callingMethod = StackTraceAnalyser.forStackTraceElement(stackTraceElement).getMethod();
            if (callingMethod == null || callingMethod.getAnnotation(BlurScreenshots.class) == null) continue;
            return Optional.of((Object)((Object)callingMethod.getAnnotation(BlurScreenshots.class).value()));
        }
        return Optional.absent();
    }
}

