/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.PackageAnnotationBasedTagProvider;
import net.thucydides.core.requirements.ReleaseProvider;
import net.thucydides.core.requirements.RequirementsMerger;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.statistics.service.AnnotationBasedTagProvider;
import net.thucydides.core.statistics.service.FeatureStoryTagProvider;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequirementsServiceImplementation
implements RequirementsService {
    private List<RequirementsTagProvider> requirementsTagProviders;
    private List<Requirement> requirements;
    private List<Release> releases;
    private Map<Requirement, List<Requirement>> requirementAncestors;
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    private static final List<Requirement> NO_REQUIREMENTS = Lists.newArrayList();
    private static final List<String> LOW_PRIORITY_PROVIDERS = ImmutableList.of((Object)FileSystemRequirementsTagProvider.class.getCanonicalName(), (Object)PackageAnnotationBasedTagProvider.class.getCanonicalName(), (Object)AnnotationBasedTagProvider.class.getCanonicalName(), (Object)FeatureStoryTagProvider.class.getCanonicalName());
    ReleaseManager releaseManager;
    Map<TestOutcome, Optional<Requirement>> requirementCache = Maps.newConcurrentMap();

    public RequirementsServiceImplementation() {
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
    }

    @Override
    public List<Requirement> getRequirements() {
        RequirementsMerger merger = new RequirementsMerger();
        if (this.requirements == null) {
            this.requirements = Lists.newArrayList();
            for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
                LOGGER.debug("Reading requirements from " + tagProvider);
                List<Requirement> newRequirements = tagProvider.getRequirements();
                this.requirements = merger.merge(this.requirements, newRequirements);
            }
            this.requirements = this.addParentsTo(this.requirements);
            this.indexRequirements();
            LOGGER.debug("Requirements found:" + this.requirements);
        }
        return this.requirements;
    }

    private List<Requirement> addParentsTo(List<Requirement> requirements) {
        return this.addParentsTo(requirements, null);
    }

    private List<Requirement> addParentsTo(List<Requirement> requirements, String parent) {
        ArrayList augmentedRequirements = Lists.newArrayList();
        for (Requirement requirement : requirements) {
            List<Requirement> children = requirement.hasChildren() ? this.addParentsTo(requirement.getChildren(), requirement.getName()) : NO_REQUIREMENTS;
            augmentedRequirements.add(requirement.withParent(parent).withChildren(children));
        }
        return augmentedRequirements;
    }

    private void indexRequirements() {
        this.requirementAncestors = Maps.newHashMap();
        for (Requirement requirement : this.requirements) {
            ImmutableList requirementPath = ImmutableList.of((Object)requirement);
            this.requirementAncestors.put(requirement, (List<Requirement>)ImmutableList.of((Object)requirement));
            LOGGER.debug("Requirement ancestors for:" + requirement + " = " + requirementPath);
            this.indexChildRequirements((List<Requirement>)requirementPath, requirement.getChildren());
        }
    }

    private ReleaseManager getReleaseManager() {
        if (this.releaseManager == null) {
            ReportNameProvider defaultNameProvider = new ReportNameProvider();
            this.releaseManager = new ReleaseManager(this.environmentVariables, defaultNameProvider);
        }
        return this.releaseManager;
    }

    private Map<Requirement, List<Requirement>> getRequirementAncestors() {
        if (this.requirementAncestors == null) {
            this.getRequirements();
        }
        return this.requirementAncestors;
    }

    private void indexChildRequirements(List<Requirement> ancestors, List<Requirement> children) {
        for (Requirement requirement : children) {
            ArrayList requirementPath = Lists.newArrayList(ancestors);
            requirementPath.add(requirement);
            this.requirementAncestors.put(requirement, (List<Requirement>)ImmutableList.copyOf((Collection)requirementPath));
            LOGGER.debug("Requirement ancestors for:" + requirement + " = " + requirementPath);
            this.indexChildRequirements(requirementPath, requirement.getChildren());
        }
    }

    @Override
    public Optional<Requirement> getParentRequirementFor(TestOutcome testOutcome) {
        try {
            for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
                Optional<Requirement> requirement = this.getParentRequirementOf(testOutcome, tagProvider);
                if (!requirement.isPresent()) continue;
                return requirement;
            }
        }
        catch (RuntimeException handleTagProvidersElegantly) {
            LOGGER.error("Tag provider failure", (Throwable)handleTagProvidersElegantly);
        }
        return Optional.absent();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag tag) {
        try {
            for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
                Optional<Requirement> requirement = tagProvider.getRequirementFor(tag);
                if (!requirement.isPresent()) continue;
                return requirement;
            }
        }
        catch (RuntimeException handleTagProvidersElegantly) {
            LOGGER.error("Tag provider failure", (Throwable)handleTagProvidersElegantly);
        }
        return Optional.absent();
    }

    @Override
    public boolean isRequirementsTag(TestTag tag) {
        return this.getRequirementTypes().contains(tag.getType());
    }

    @Override
    public List<Requirement> getAncestorRequirementsFor(TestOutcome testOutcome) {
        for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
            Optional<Requirement> requirement = this.getParentRequirementOf(testOutcome, tagProvider);
            if (!requirement.isPresent()) continue;
            LOGGER.debug("Requirement found for test outcome " + testOutcome.getTitle() + "-" + testOutcome.getIssueKeys() + ": " + requirement);
            if (this.getRequirementAncestors().containsKey(requirement.get())) {
                return this.getRequirementAncestors().get(requirement.get());
            }
            LOGGER.warn("Requirement without identified ancestors found:" + ((Requirement)requirement.get()).getCardNumber());
        }
        return Collections.EMPTY_LIST;
    }

    private Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome, RequirementsTagProvider tagProvider) {
        if (this.requirementCache.containsKey(testOutcome)) {
            return this.requirementCache.get(testOutcome);
        }
        Optional<Requirement> parentRequirement = this.findMatchingIndexedRequirement(tagProvider.getParentRequirementOf(testOutcome));
        this.requirementCache.put(testOutcome, parentRequirement);
        return parentRequirement;
    }

    private Optional<Requirement> findMatchingIndexedRequirement(Optional<Requirement> requirement) {
        if (!requirement.isPresent()) {
            return requirement;
        }
        for (Requirement indexedRequirement : this.getAllRequirements()) {
            if (!((Requirement)requirement.get()).matches(indexedRequirement)) continue;
            return Optional.of((Object)indexedRequirement);
        }
        return Optional.absent();
    }

    @Override
    public List<String> getReleaseVersionsFor(TestOutcome testOutcome) {
        ArrayList releases = Lists.newArrayList(testOutcome.getVersions());
        for (Requirement parentRequirement : this.getAncestorRequirementsFor(testOutcome)) {
            releases.addAll(parentRequirement.getReleaseVersions());
        }
        return releases;
    }

    @Override
    public List<Release> getReleasesFromRequirements() {
        if (this.releases == null) {
            if (this.getReleaseProvider().isPresent() && ((ReleaseProvider)this.getReleaseProvider().get()).isActive()) {
                this.releases = ((ReleaseProvider)this.getReleaseProvider().get()).getReleases();
            } else {
                List<List<String>> releaseVersions = this.getReleaseVersionsFrom(this.getRequirements());
                this.releases = this.getReleaseManager().extractReleasesFrom(releaseVersions);
            }
        }
        return this.releases;
    }

    private Optional<ReleaseProvider> getReleaseProvider() {
        List<RequirementsTagProvider> requirementsTagProviders = this.getRequirementsTagProviders();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (!(provider instanceof ReleaseProvider) || !((ReleaseProvider)((Object)provider)).isActive()) continue;
            return Optional.of((Object)((ReleaseProvider)((Object)provider)));
        }
        return Optional.absent();
    }

    @Override
    public List<String> getRequirementTypes() {
        HashSet requirementTypes = Sets.newHashSet();
        for (Requirement requirement : this.getAllRequirements()) {
            requirementTypes.add(requirement.getType());
        }
        return ImmutableList.copyOf((Collection)requirementTypes);
    }

    private List<List<String>> getReleaseVersionsFrom(List<Requirement> requirements) {
        ArrayList releaseVersions = Lists.newArrayList();
        for (Requirement requirement : requirements) {
            releaseVersions.add(requirement.getReleaseVersions());
            releaseVersions.addAll(this.getReleaseVersionsFrom(requirement.getChildren()));
        }
        return releaseVersions;
    }

    private List<RequirementsTagProvider> getRequirementsTagProviders() {
        if (this.requirementsTagProviders == null) {
            RequirementsProviderService requirementsProviderService = (RequirementsProviderService)Injectors.getInjector().getInstance(RequirementsProviderService.class);
            this.requirementsTagProviders = this.reprioritizeProviders(this.active(requirementsProviderService.getRequirementsProviders()));
        }
        return this.requirementsTagProviders;
    }

    private List<RequirementsTagProvider> active(List<RequirementsTagProvider> requirementsProviders) {
        boolean useDirectoryBasedRequirements = ThucydidesSystemProperty.THUCYDIDES_USE_REQUIREMENTS_DIRECTORIES.booleanFrom(this.environmentVariables, true);
        if (useDirectoryBasedRequirements) {
            return requirementsProviders;
        }
        ArrayList activeRequirementsProviders = Lists.newArrayList();
        for (RequirementsTagProvider provider : requirementsProviders) {
            if (provider instanceof FileSystemRequirementsTagProvider) continue;
            activeRequirementsProviders.add(provider);
        }
        return activeRequirementsProviders;
    }

    private List<RequirementsTagProvider> reprioritizeProviders(List<RequirementsTagProvider> requirementsTagProviders) {
        HashMap lowPriorityProviders = Maps.newHashMap();
        ArrayList prioritizedProviders = Lists.newArrayList();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (LOW_PRIORITY_PROVIDERS.contains(provider.getClass().getCanonicalName())) {
                lowPriorityProviders.put(provider.getClass().getCanonicalName(), provider);
                continue;
            }
            prioritizedProviders.add(provider);
        }
        this.addLowPriorityProviders(lowPriorityProviders, prioritizedProviders);
        return prioritizedProviders;
    }

    private void addLowPriorityProviders(Map<String, RequirementsTagProvider> lowPriorityProviders, List<RequirementsTagProvider> prioritizedProviders) {
        for (String lowPriorityProvider : LOW_PRIORITY_PROVIDERS) {
            if (!lowPriorityProviders.containsKey(lowPriorityProvider)) continue;
            prioritizedProviders.add(lowPriorityProviders.get(lowPriorityProvider));
        }
    }

    public List<Requirement> getAllRequirements() {
        ArrayList allRequirements = Lists.newArrayList();
        this.addRequirementsFrom(this.getRequirements(), allRequirements);
        return allRequirements;
    }

    private void addRequirementsFrom(List<Requirement> requirements, List<Requirement> allRequirements) {
        allRequirements.addAll(requirements);
        for (Requirement requirement : requirements) {
            this.addRequirementsFrom(requirement.getChildren(), allRequirements);
        }
    }
}

