/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import java.util.Set;
import net.thucydides.core.webelements.MultipleSelect;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class Dropdown {
    private final WebElement dropdown;
    private final Select selectField;

    private Dropdown(WebElement dropdown) {
        this.dropdown = dropdown;
        this.selectField = new Select(dropdown);
    }

    public static Dropdown forWebElement(WebElement webElement) {
        return new Dropdown(webElement);
    }

    public void select(String visibleLabel) {
        this.selectField.selectByVisibleText(visibleLabel);
    }

    public void selectByValue(String value) {
        this.selectField.selectByValue(value);
    }

    public void selectMultipleItems(String ... selectedLabels) {
        Select select = new Select(this.dropdown);
        for (String selectedLabel : selectedLabels) {
            select.selectByVisibleText(selectedLabel);
        }
    }

    public Set<String> getSelectedOptionLabels() {
        MultipleSelect multipleSelect = new MultipleSelect(this.dropdown);
        return multipleSelect.getSelectedOptionLabels();
    }

    public Set<String> getSelectedOptionValues() {
        MultipleSelect multipleSelect = new MultipleSelect(this.dropdown);
        return multipleSelect.getSelectedOptionValues();
    }

    public String getSelectedValue() {
        return this.selectField.getFirstSelectedOption().getAttribute("value");
    }

    public String getSelectedLabel() {
        return this.selectField.getFirstSelectedOption().getText();
    }
}

