/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.stacktrace;

import net.serenitybdd.core.exceptions.SerenityWebDriverException;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.model.stacktrace.StackTraceSanitizer;
import net.thucydides.core.webdriver.WebdriverAssertionError;

public class RootCauseAnalyzer {
    private final Throwable thrownException;

    public RootCauseAnalyzer(Throwable thrownException) {
        this.thrownException = thrownException;
    }

    public FailureCause getRootCause() {
        Throwable originalException = this.originalExceptionFrom(this.thrownException);
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace(originalException.getStackTrace());
        return new FailureCause(originalException, stackTraceSanitizer.getSanitizedStackTrace());
    }

    private Throwable originalExceptionFrom(Throwable thrownException) {
        if (!(thrownException instanceof WebdriverAssertionError) && (thrownException instanceof SerenityWebDriverException || thrownException instanceof AssertionError)) {
            return thrownException;
        }
        return thrownException.getCause() != null ? thrownException.getCause() : thrownException;
    }

    public String getClassname() {
        return this.getRootCause().getErrorType();
    }

    public String getMessage() {
        return this.getRootCause().getMessage() != null ? this.getRootCause().getMessage().replace("java.lang.AssertionError", "") : this.getRootCause().getMessage();
    }
}

