/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageSourceRecorder {
    private final WebDriver driver;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public PageSourceRecorder(WebDriver driver) {
        this.driver = driver;
    }

    public Optional<File> intoDirectory(Path path) {
        try {
            Path pageSourceFile = Files.createTempFile(path, "pagesource", ".html.txt", new FileAttribute[0]);
            Files.write(pageSourceFile, this.pageSource(), new OpenOption[0]);
            return Optional.of((Object)pageSourceFile.toFile());
        }
        catch (IOException couldNotCreatePageSourcce) {
            this.LOGGER.warn("Could not save the page source HTML file", (Throwable)couldNotCreatePageSourcce);
            return Optional.absent();
        }
    }

    private byte[] pageSource() {
        if (this.driver.getPageSource() == null) {
            return new byte[0];
        }
        return this.driver.getPageSource().getBytes();
    }
}

