/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Splitter;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.net.URL;
import java.util.List;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.exceptions.SerenityWebDriverException;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.SafariDriver;

public class WebdriverInstanceFactory {
    private DriverCapabilityRecord driverProperties = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);

    public WebDriver newInstanceOf(Class<? extends WebDriver> webdriverClass) throws IllegalAccessException, InstantiationException {
        return webdriverClass.newInstance();
    }

    public WebDriver newRemoteDriver(URL remoteUrl, Capabilities capabilities) {
        try {
            RemoteWebDriver driver = new RemoteWebDriver(remoteUrl, capabilities);
            this.driverProperties.registerCapabilities("remote", driver.getCapabilities());
            return driver;
        }
        catch (UnreachableBrowserException unreachableBrowser) {
            String errorMessage = this.unreachableBrowserErrorMessage(unreachableBrowser);
            throw new SerenityWebDriverException(errorMessage, (WebDriverException)unreachableBrowser);
        }
    }

    private String unreachableBrowserErrorMessage(UnreachableBrowserException unreachableBrowser) {
        List errorLines = Splitter.onPattern((String)"\n").splitToList((CharSequence)unreachableBrowser.getLocalizedMessage());
        Throwable cause = unreachableBrowser.getCause();
        String errorCause = cause == null ? "" : System.lineSeparator() + cause.getClass().getSimpleName() + " - " + cause.getLocalizedMessage();
        return (String)errorLines.get(0) + errorCause;
    }

    public WebDriver newFirefoxDriver(Capabilities capabilities) {
        FirefoxDriver driver = new FirefoxDriver(capabilities);
        this.driverProperties.registerCapabilities("firefox", driver.getCapabilities());
        return driver;
    }

    public WebDriver newChromeDriver(Capabilities capabilities) {
        ChromeDriver driver = new ChromeDriver(capabilities);
        this.driverProperties.registerCapabilities("chrome", driver.getCapabilities());
        return driver;
    }

    public WebDriver newAppiumDriver(URL hub, Capabilities capabilities, MobilePlatform platform) {
        switch (platform) {
            case ANDROID: {
                AndroidDriver androidDriver = new AndroidDriver(hub, capabilities);
                this.driverProperties.registerCapabilities("appium", androidDriver.getCapabilities());
                return androidDriver;
            }
            case IOS: {
                IOSDriver iosDriver = new IOSDriver(hub, capabilities);
                this.driverProperties.registerCapabilities("appium", iosDriver.getCapabilities());
                return iosDriver;
            }
        }
        throw new UnsupportedDriverException(platform.name());
    }

    public WebDriver newSafariDriver(Capabilities capabilities) {
        SafariDriver driver = new SafariDriver(capabilities);
        this.driverProperties.registerCapabilities("chrome", driver.getCapabilities());
        return driver;
    }

    public WebDriver newInternetExplorerDriver(Capabilities capabilities) {
        InternetExplorerDriver driver = new InternetExplorerDriver(capabilities);
        this.driverProperties.registerCapabilities("iexplorer", driver.getCapabilities());
        return driver;
    }

    public WebDriver newHtmlUnitDriver(Capabilities capabilities) {
        HtmlUnitDriver driver = new HtmlUnitDriver(capabilities);
        this.driverProperties.registerCapabilities("htmlunit", driver.getCapabilities());
        return driver;
    }

    public WebDriver newPhantomDriver(Capabilities capabilities) {
        PhantomJSDriver driver = new PhantomJSDriver(capabilities);
        this.driverProperties.registerCapabilities("phantomjs", driver.getCapabilities());
        return driver;
    }
}

