/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;

public class AbstractRequirementsTagProvider {
    protected final EnvironmentVariables environmentVariables;
    protected final String rootDirectory;
    protected final RequirementsConfiguration requirementsConfiguration;
    protected final RequirementsService requirementsService;

    protected AbstractRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
        this.rootDirectory = this.getDefaultRootDirectory();
    }

    protected String humanReadableVersionOf(String name) {
        String underscoredName = Inflector.getInstance().underscore(name, new char[0]);
        return Inflector.getInstance().humanize(underscoredName, new String[0]);
    }

    protected String getDefaultType(int level, int maxDepth) {
        List<String> types = this.getRequirementTypes();
        int relativeLevel = types.size() - 1 - maxDepth + level;
        if (relativeLevel > types.size() - 1) {
            return types.get(types.size() - 1);
        }
        if (relativeLevel >= 0) {
            return types.get(relativeLevel);
        }
        return types.get(0);
    }

    protected String getDefaultType(int level) {
        return this.getDefaultType(level, this.getRequirementTypes().size() - 1);
    }

    protected List<String> getRequirementTypes() {
        return this.requirementsConfiguration.getRequirementTypes();
    }

    protected String getDefaultRootDirectory() {
        return this.requirementsConfiguration.getDefaultRootDirectory();
    }
}

