/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.images;

import com.jayway.awaitility.Awaitility;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.thucydides.core.images.ResizedImage;
import net.thucydides.core.images.SimpleImageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizableImage {
    private final File screenshotFile;
    private final SimpleImageInfo imageInfo;
    private final int MAX_SUPPORTED_HEIGHT = 4000;
    private final Logger logger = LoggerFactory.getLogger(ResizableImage.class);

    protected Logger getLogger() {
        return this.logger;
    }

    public ResizableImage(File screenshotFile) throws IOException {
        this.screenshotFile = screenshotFile;
        this.imageInfo = new SimpleImageInfo(screenshotFile);
    }

    public static ResizableImage loadFrom(File screenshotFile) throws IOException {
        return new ResizableImage(screenshotFile);
    }

    public int getWitdh() {
        return this.imageInfo.getWidth();
    }

    public int getHeight() {
        return this.imageInfo.getHeight();
    }

    public ResizableImage rescaleCanvas(int height) throws IOException {
        if (this.skipRescale(height)) {
            return this;
        }
        int targetHeight = Math.min(height, 4000);
        try {
            this.waitForCreationOfFile();
            BufferedImage image = ImageIO.read(this.screenshotFile);
            int width = new SimpleImageInfo(this.screenshotFile).getWidth();
            return this.resizeImage(width, targetHeight, image);
        }
        catch (Throwable e) {
            this.getLogger().warn("Could not resize screenshot, so leaving original version: " + this.screenshotFile, e);
            return this;
        }
    }

    private void waitForCreationOfFile() {
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(this.screenshotIsProcessed());
    }

    private Callable<Boolean> screenshotIsProcessed() {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ResizableImage.this.screenshotFile.exists() && ResizableImage.this.screenshotFile.length() > 0L;
            }
        };
    }

    protected ResizableImage resizeImage(int width, int targetHeight, BufferedImage image) throws IOException {
        try {
            int imageType = image.getType() > 0 ? image.getType() : 6;
            BufferedImage resizedImage = new BufferedImage(width, targetHeight, imageType);
            this.fillWithWhiteBackground(resizedImage);
            resizedImage.setData(image.getRaster());
            return new ResizedImage(resizedImage, this.screenshotFile);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean skipRescale(int height) {
        if (this.getHeight() > 4000) {
            return true;
        }
        return this.getHeight() >= height;
    }

    private void fillWithWhiteBackground(BufferedImage resizedImage) {
        Graphics2D g2d = resizedImage.createGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, resizedImage.getWidth(), resizedImage.getHeight()));
        g2d.dispose();
    }

    public void saveTo(File savedFile) throws IOException {
        Files.copy(this.screenshotFile.toPath(), savedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

