/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.thucydides.core.annotations.locators.AbstractSingleItemHandler;
import net.thucydides.core.annotations.locators.ElementContructorForm;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class SmartElementHandler
extends AbstractSingleItemHandler<WebElementFacade> {
    private static final String NO_SUITABLE_CONSTRUCTOR_FOUND_FMT2 = "No suitable constructor found.  Expected:  %s(WebDriver, ElementLocator, long, long) or %s(WebDriver, ElementLocator, WebElement, long, long)";

    public SmartElementHandler(Class<?> interfaceType, ElementLocator locator, PageObject page) {
        super(WebElementFacade.class, interfaceType, locator, page);
    }

    @Override
    protected Object newElementInstance() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object instance = null;
        if (ElementContructorForm.applicableConstructor(this.implementerClass).isPresent()) {
            Constructor constructor = (Constructor)ElementContructorForm.applicableConstructorFrom(this.implementerClass).get();
            switch ((ElementContructorForm)((Object)ElementContructorForm.applicableConstructor(this.implementerClass).get())) {
                case WEBDRIVER_LOCATOR_SINGLE_TIMEOUT: {
                    instance = constructor.newInstance(this.page.getDriver(), this.locator, this.page.getImplicitWaitTimeout().in(TimeUnit.MILLISECONDS));
                    break;
                }
                case WEBDRIVER_LOCATOR_TWO_TIMEOUTS: {
                    instance = constructor.newInstance(this.page.getDriver(), this.locator, this.page.getImplicitWaitTimeout().in(TimeUnit.MILLISECONDS), this.page.getWaitForTimeout().in(TimeUnit.MILLISECONDS));
                    break;
                }
                case WEBDRIVER_ELEMENT_SINGLE_TIMEOUT: {
                    instance = constructor.newInstance(this.page.getDriver(), this.locator, null, this.page.getImplicitWaitTimeout().in(TimeUnit.MILLISECONDS));
                    break;
                }
                case WEBDRIVER_ELEMENT_TWO_TIMEOUTS: {
                    instance = constructor.newInstance(this.page.getDriver(), this.locator, null, this.page.getImplicitWaitTimeout().in(TimeUnit.MILLISECONDS), this.page.getWaitForTimeout().in(TimeUnit.MILLISECONDS));
                }
            }
        }
        if (instance == null) {
            String className = this.implementerClass.getSimpleName();
            throw new RuntimeException(String.format(NO_SUITABLE_CONSTRUCTOR_FOUND_FMT2, className, className));
        }
        return instance;
    }
}

